/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.combined;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.extension.issues.model.SelectableIssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.MultiSelection;
import net.nemerosa.ontrack.model.support.Configuration;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;

public class CombinedIssueServiceConfiguration
implements Configuration,
IssueServiceConfiguration {
    private final String name;
    private final List<String> issueServiceConfigurationIdentifiers;

    @JsonIgnore
    public String getServiceId() {
        return "combined";
    }

    @JsonIgnore
    public ConfigurationDescriptor getDescriptor() {
        return new ConfigurationDescriptor(this.name, this.name);
    }

    public Configuration obfuscate() {
        return this;
    }

    public static Form form(List<IssueServiceConfigurationRepresentation> availableIssueServiceConfigurations) {
        return new CombinedIssueServiceConfiguration("", Collections.emptyList()).asForm(availableIssueServiceConfigurations);
    }

    public Form asForm(List<IssueServiceConfigurationRepresentation> availableIssueServiceConfigurations) {
        return Form.create().with((Field)Form.defaultNameField().value((Object)this.name)).with((Field)((MultiSelection)((MultiSelection)MultiSelection.of((String)"issueServiceConfigurationIdentifiers").label("Issue services")).help("List of issue services to combine.")).items(availableIssueServiceConfigurations.stream().map(issueServiceConfigurationRepresentation -> new SelectableIssueServiceConfigurationRepresentation(issueServiceConfigurationRepresentation, this.issueServiceConfigurationIdentifiers.contains(issueServiceConfigurationRepresentation.getId()))).collect(Collectors.toList())));
    }

    @ConstructorProperties(value={"name", "issueServiceConfigurationIdentifiers"})
    public CombinedIssueServiceConfiguration(String name, List<String> issueServiceConfigurationIdentifiers) {
        this.name = name;
        this.issueServiceConfigurationIdentifiers = issueServiceConfigurationIdentifiers;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIssueServiceConfigurationIdentifiers() {
        return this.issueServiceConfigurationIdentifiers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CombinedIssueServiceConfiguration)) {
            return false;
        }
        CombinedIssueServiceConfiguration other = (CombinedIssueServiceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$issueServiceConfigurationIdentifiers = this.getIssueServiceConfigurationIdentifiers();
        List<String> other$issueServiceConfigurationIdentifiers = other.getIssueServiceConfigurationIdentifiers();
        return !(this$issueServiceConfigurationIdentifiers == null ? other$issueServiceConfigurationIdentifiers != null : !((Object)this$issueServiceConfigurationIdentifiers).equals(other$issueServiceConfigurationIdentifiers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CombinedIssueServiceConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        List<String> $issueServiceConfigurationIdentifiers = this.getIssueServiceConfigurationIdentifiers();
        result = result * 59 + ($issueServiceConfigurationIdentifiers == null ? 0 : ((Object)$issueServiceConfigurationIdentifiers).hashCode());
        return result;
    }

    public String toString() {
        return "CombinedIssueServiceConfiguration(name=" + this.getName() + ", issueServiceConfigurationIdentifiers=" + this.getIssueServiceConfigurationIdentifiers() + ")";
    }
}

