/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.artifactory;

import java.util.List;
import net.nemerosa.ontrack.extension.artifactory.client.ArtifactoryClientFactory;
import net.nemerosa.ontrack.extension.artifactory.configuration.ArtifactoryConfiguration;
import net.nemerosa.ontrack.extension.support.ConfigurationHealthIndicator;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.stereotype.Component;

@Component
public class ArtifactoryHealthIndicator
extends ConfigurationHealthIndicator<ArtifactoryConfiguration> {
    private final ArtifactoryClientFactory clientFactory;

    @Autowired
    public ArtifactoryHealthIndicator(ConfigurationService<ArtifactoryConfiguration> configurationService, SecurityService securityService, HealthAggregator healthAggregator, ArtifactoryClientFactory clientFactory) {
        super(configurationService, securityService, healthAggregator);
        this.clientFactory = clientFactory;
    }

    protected Health getHealth(ArtifactoryConfiguration config) {
        try {
            List<String> buildNames = this.clientFactory.getClient(config).getBuildNames();
            return Health.up().withDetail("buildNames", buildNames).build();
        }
        catch (Exception ex) {
            return Health.down((Exception)ex).build();
        }
    }
}

