"use strict";angular.module("ontrack.extension.artifactory",["ui.router","ot.service.core","ot.service.configuration","ot.service.form"]).config(["$stateProvider",function(t){t.state("artifactory-configurations",{url:"/extension/artifactory/configurations",templateUrl:"extension/artifactory/artifactory.configurations.tpl.html",controller:"ArtifactoryConfigurationsCtrl"})}]).controller("ArtifactoryConfigurationsCtrl",["$scope","$http","ot","otFormService","otAlertService","otConfigurationService",function(t,o,i,n,e,r){function a(){i.call(o.get("extension/artifactory/configurations")).then(function(o){t.configurations=o,c.commands=[{id:"artifactory-configuration-create",name:"Create a configuration",cls:"ot-command-new",action:t.createConfiguration},i.viewApiCommand(o._self),i.viewCloseCommand("/home")]})}var c=i.view();c.title="Artifactory configurations",c.description="Management of the Artifactory configurations.",a(),t.createConfiguration=function(){n.display({uri:t.configurations._create,title:"Artifactory configuration",buttons:[r.testButton(t.configurations._test)],submit:function(n){return i.call(o.post(t.configurations._create,n))}}).then(a)},t.deleteConfiguration=function(t){e.confirm({title:"Deleting configuration",message:"Do you really want to delete this Artifactory configuration? Some projects may still refer to it."}).then(function(){i.call(o["delete"](t._delete)).then(a)})},t.updateConfiguration=function(e){n.display({uri:e._update,title:"Artifactory configuration",buttons:[r.testButton(t.configurations._test)],submit:function(t){return i.call(o.put(e._update,t))}}).then(a)}}]);
angular.module("ontrack-extension-artifactory-templates",[]).run(["$log","$templateCache",function(n,t){n.info("Loading templates for artifactory @ 3.42.9"),t.put("extension/artifactory/artifactory.configurations.tpl.html",'<ot-view>\n    <div class="row">\n        <div class="col-md-12">\n            <ot-section-title>List of configurations</ot-section-title>\n            <ot-noentry list="configurations.resources">\n                No Artifactory configuration has been created yet.\n            </ot-noentry>\n            <table class="table table-hover">\n                <tr ng-repeat="configuration in configurations.resources">\n                    <td>\n                        <code>{{configuration.name}}</code>\n                    </td>\n                    <td>\n                        <span ng-if="configuration.user">\n                            {{configuration.user}} @\n                        </span>\n                        <a href="{{configuration.url}}" target="_blank">{{configuration.url}}</a>\n                    </td>\n                    <td>\n                        <span class="ot-command" ng-click="updateConfiguration(configuration)">\n                            <span class="ot-command-update"></span>\n                            Update\n                        </span>\n                        <span class="ot-command" ng-click="deleteConfiguration(configuration)">\n                            <span class="ot-command-delete"></span>\n                            Delete\n                        </span>\n                    </td>\n                </tr>\n            </table>\n        </div>\n    </div>\n</ot-view>'),t.put("extension/artifactory/property/net.nemerosa.ontrack.extension.artifactory.property.ArtifactoryPromotionSyncPropertyType.tpl.html","{{property.value.buildName}}\n({{property.value.buildNameFilter}})\nevery {{property.value.interval}} minute(s)")}]);