/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.artifactory.service;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.nemerosa.ontrack.extension.artifactory.ArtifactoryConfProperties;
import net.nemerosa.ontrack.extension.artifactory.client.ArtifactoryClient;
import net.nemerosa.ontrack.extension.artifactory.client.ArtifactoryClientFactory;
import net.nemerosa.ontrack.extension.artifactory.configuration.ArtifactoryConfiguration;
import net.nemerosa.ontrack.extension.artifactory.configuration.ArtifactoryConfigurationService;
import net.nemerosa.ontrack.extension.artifactory.model.ArtifactoryStatus;
import net.nemerosa.ontrack.extension.artifactory.property.ArtifactoryPromotionSyncProperty;
import net.nemerosa.ontrack.extension.artifactory.property.ArtifactoryPromotionSyncPropertyType;
import net.nemerosa.ontrack.extension.artifactory.service.ArtifactoryPromotionSyncService;
import net.nemerosa.ontrack.job.Job;
import net.nemerosa.ontrack.job.JobCategory;
import net.nemerosa.ontrack.job.JobKey;
import net.nemerosa.ontrack.job.JobRegistration;
import net.nemerosa.ontrack.job.JobRun;
import net.nemerosa.ontrack.job.JobRunListener;
import net.nemerosa.ontrack.job.JobType;
import net.nemerosa.ontrack.job.orchestrator.JobOrchestratorSupplier;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchType;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.support.AbstractBranchJob;
import net.nemerosa.ontrack.model.support.ConfigurationServiceListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactoryPromotionSyncServiceImpl
implements ArtifactoryPromotionSyncService,
JobOrchestratorSupplier,
ConfigurationServiceListener<ArtifactoryConfiguration> {
    private static final JobType ARTIFACTORY_BUILD_SYNC_JOB = JobCategory.of((String)"artifactory").withName("Artifactory").getType("build-sync").withName("Artifactory Build synchronisation");
    private final Logger logger = LoggerFactory.getLogger(ArtifactoryPromotionSyncServiceImpl.class);
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final ArtifactoryClientFactory artifactoryClientFactory;
    private final ArtifactoryConfProperties artifactoryConfProperties;
    private final SecurityService securityService;

    @Autowired
    public ArtifactoryPromotionSyncServiceImpl(StructureService structureService, PropertyService propertyService, ArtifactoryClientFactory artifactoryClientFactory, ArtifactoryConfigurationService configurationService, ArtifactoryConfProperties artifactoryConfProperties, SecurityService securityService) {
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.artifactoryClientFactory = artifactoryClientFactory;
        this.artifactoryConfProperties = artifactoryConfProperties;
        this.securityService = securityService;
        configurationService.addConfigurationServiceListener(this);
    }

    public Stream<JobRegistration> collectJobRegistrations() {
        if (this.artifactoryConfProperties.isBuildSyncDisabled()) {
            return Stream.empty();
        }
        return (Stream)this.securityService.asAdmin(() -> this.structureService.getProjectList().stream().flatMap(project -> this.structureService.getBranchesForProject(project.getId()).stream()).filter(branch -> branch.getType() != BranchType.TEMPLATE_DEFINITION).filter(branch -> this.propertyService.hasProperty((ProjectEntity)branch, ArtifactoryPromotionSyncPropertyType.class)).map(this::scheduleArtifactoryBuildSync));
    }

    public JobRegistration scheduleArtifactoryBuildSync(Branch branch) {
        ArtifactoryPromotionSyncProperty property = (ArtifactoryPromotionSyncProperty)this.propertyService.getProperty((ProjectEntity)branch, ArtifactoryPromotionSyncPropertyType.class).getValue();
        return JobRegistration.of((Job)this.getBranchSyncJob(branch)).everyMinutes((long)property.getInterval());
    }

    private JobKey getBranchSyncJobKey(Branch branch) {
        return ARTIFACTORY_BUILD_SYNC_JOB.getKey(branch.getId().toString());
    }

    private Job getBranchSyncJob(final Branch branch) {
        return (Job)this.propertyService.getProperty((ProjectEntity)branch, ArtifactoryPromotionSyncPropertyType.class).option().map(syncProperty -> new AbstractBranchJob(this.structureService, branch){

            public JobKey getKey() {
                return ArtifactoryPromotionSyncServiceImpl.this.getBranchSyncJobKey(branch);
            }

            public JobRun getTask() {
                return runListener -> ArtifactoryPromotionSyncServiceImpl.this.sync(branch, runListener);
            }

            public String getDescription() {
                return String.format("Synchronisation of promotions with Artifactory for branch %s/%s", branch.getProject().getName(), branch.getName());
            }

            public boolean isValid() {
                return super.isValid() && ArtifactoryPromotionSyncServiceImpl.this.propertyService.hasProperty((ProjectEntity)branch, ArtifactoryPromotionSyncPropertyType.class);
            }
        }).orElseThrow(() -> new IllegalStateException("Branch not configured for Artifactory"));
    }

    private void sync(Branch branch, JobRunListener listener) {
        Property syncProperty = this.propertyService.getProperty((ProjectEntity)branch, ArtifactoryPromotionSyncPropertyType.class);
        if (syncProperty.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot find sync. property on branch %d", branch.id()));
        }
        String buildName = ((ArtifactoryPromotionSyncProperty)syncProperty.getValue()).getBuildName();
        String buildNameFilter = ((ArtifactoryPromotionSyncProperty)syncProperty.getValue()).getBuildNameFilter();
        ArtifactoryConfiguration configuration = ((ArtifactoryPromotionSyncProperty)syncProperty.getValue()).getConfiguration();
        String log = String.format("Sync branch %s/%s with Artifactory build %s (%s)", branch.getProject().getName(), branch.getName(), buildName, buildNameFilter);
        this.logger.info("[artifactory-sync] {}", (Object)log);
        listener.message(log, new Object[0]);
        Pattern buildNamePattern = Pattern.compile(StringUtils.replace((String)StringUtils.replace((String)buildNameFilter, (String)".", (String)"\\."), (String)"*", (String)".*"));
        ArtifactoryClient client = this.artifactoryClientFactory.getClient(configuration);
        List buildNumbers = client.getBuildNumbers(buildName).stream().filter(name -> buildNamePattern.matcher((CharSequence)name).matches()).collect(Collectors.toList());
        for (String buildNumber : buildNumbers) {
            this.syncBuild(branch, buildName, buildNumber, client, listener);
        }
    }

    protected void syncBuild(Branch branch, String artifactoryBuildName, String buildName, ArtifactoryClient client, JobRunListener listener) {
        Optional buildOpt = this.structureService.findBuildByName(branch.getProject().getName(), branch.getName(), buildName);
        if (buildOpt.isPresent()) {
            String log = String.format("Sync branch %s/%s for Artifactory build %s", branch.getProject().getName(), branch.getName(), buildName);
            this.logger.debug("[artifactory-sync] {}", (Object)log);
            listener.message(log, new Object[0]);
            JsonNode buildInfo = client.getBuildInfo(artifactoryBuildName, buildName);
            List<ArtifactoryStatus> statuses = client.getStatuses(buildInfo);
            for (ArtifactoryStatus artifactoryStatus : statuses) {
                Optional runOpt;
                String statusName = artifactoryStatus.getName();
                Optional promotionLevelOpt = this.structureService.findPromotionLevelByName(branch.getProject().getName(), branch.getName(), statusName);
                if (!promotionLevelOpt.isPresent() || (runOpt = this.structureService.getLastPromotionRunForBuildAndPromotionLevel((Build)buildOpt.get(), (PromotionLevel)promotionLevelOpt.get())).isPresent()) continue;
                this.logger.info("[artifactory-sync] Promote {}/{}/{} to {}", new Object[]{branch.getProject().getName(), branch.getName(), buildName, statusName});
                this.structureService.newPromotionRun(PromotionRun.of((Build)((Build)buildOpt.get()), (PromotionLevel)((PromotionLevel)promotionLevelOpt.get()), (Signature)Signature.of((String)artifactoryStatus.getUser()).withTime(artifactoryStatus.getTimestamp()), (String)"Promoted from Artifactory"));
            }
        }
    }
}

