/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.artifactory.property;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.common.MapBuilder;
import net.nemerosa.ontrack.extension.artifactory.ArtifactoryExtensionFeature;
import net.nemerosa.ontrack.extension.artifactory.configuration.ArtifactoryConfiguration;
import net.nemerosa.ontrack.extension.artifactory.configuration.ArtifactoryConfigurationService;
import net.nemerosa.ontrack.extension.artifactory.property.ArtifactoryPromotionSyncProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.support.ConfigurationPropertyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArtifactoryPromotionSyncPropertyType
extends AbstractPropertyType<ArtifactoryPromotionSyncProperty>
implements ConfigurationPropertyType<ArtifactoryConfiguration, ArtifactoryPromotionSyncProperty> {
    private final ArtifactoryConfigurationService configurationService;

    @Autowired
    public ArtifactoryPromotionSyncPropertyType(ArtifactoryExtensionFeature extensionFeature, ArtifactoryConfigurationService configurationService) {
        super((ExtensionFeature)extensionFeature);
        this.configurationService = configurationService;
    }

    public String getName() {
        return "Artifactory promotion sync";
    }

    public String getDescription() {
        return "Synchronisation of the promotions with Artifactory build statuses";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.BRANCH);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity.projectId(), ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity.projectId(), ProjectConfig.class);
    }

    public Form getEditionForm(ProjectEntity entity, ArtifactoryPromotionSyncProperty value) {
        return Form.create().with((Field)((Selection)((Selection)Selection.of((String)"configuration").label("Configuration")).help("Configuration to use to access Artifactory")).items(this.configurationService.getConfigurationDescriptors()).value(value != null ? value.getConfiguration().getName() : null)).with((Field)((Text)((Text)Text.of((String)"buildName").label("Build name")).help("Name of the Artifactory build")).value((Object)(value != null ? value.getBuildName() : ""))).with((Field)((Text)((Text)Text.of((String)"buildNameFilter").label("Build name filter")).help("Filter on the build name in Artifactory (* can be used as a wildcard)")).value((Object)(value != null ? value.getBuildNameFilter() : ""))).with((Field)((Int)((Int)Int.of((String)"interval").label("Sync. interval (min)")).min(0).max(10080).help("Interval in minutes for the synchronisation. If 0, no synchronisation is done.")).value((Object)(value != null ? value.getInterval() : 0)));
    }

    public JsonNode forStorage(ArtifactoryPromotionSyncProperty value) {
        return ArtifactoryPromotionSyncPropertyType.format((Object)MapBuilder.params().with((Object)"configuration", (Object)value.getConfiguration().getName()).with((Object)"buildName", (Object)value.getBuildName()).with((Object)"buildNameFilter", (Object)value.getBuildNameFilter()).with((Object)"interval", (Object)value.getInterval()).get());
    }

    public ArtifactoryPromotionSyncProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public ArtifactoryPromotionSyncProperty fromStorage(JsonNode node) {
        String configurationName = node.path("configuration").asText();
        String buildName = node.path("buildName").asText();
        String buildNameFilter = node.path("buildNameFilter").asText();
        int interval = node.path("interval").asInt();
        ArtifactoryConfiguration configuration = (ArtifactoryConfiguration)this.configurationService.getConfiguration(configurationName);
        this.validateNotBlank(buildName, "The build name must not be empty");
        if (interval < 0) {
            interval = 0;
        }
        return new ArtifactoryPromotionSyncProperty(configuration, buildName, buildNameFilter, interval);
    }

    public String getSearchKey(ArtifactoryPromotionSyncProperty value) {
        return value.getConfiguration().getName();
    }

    public ArtifactoryPromotionSyncProperty replaceValue(ArtifactoryPromotionSyncProperty value, Function<String, String> replacementFunction) {
        return new ArtifactoryPromotionSyncProperty((ArtifactoryConfiguration)this.configurationService.replaceConfiguration(value.getConfiguration(), replacementFunction), replacementFunction.apply(value.getBuildName()), replacementFunction.apply(value.getBuildNameFilter()), value.getInterval());
    }
}

