/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.artifactory.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.nemerosa.ontrack.client.ClientNotFoundException;
import net.nemerosa.ontrack.client.JsonClient;
import net.nemerosa.ontrack.extension.artifactory.client.ArtifactoryClient;
import net.nemerosa.ontrack.extension.artifactory.model.ArtifactoryStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class ArtifactoryClientImpl
implements ArtifactoryClient {
    private final JsonClient jsonClient;

    public ArtifactoryClientImpl(JsonClient jsonClient) {
        this.jsonClient = jsonClient;
    }

    @Override
    public JsonClient getJsonClient() {
        return this.jsonClient;
    }

    @Override
    public JsonNode aql(String query) {
        return this.jsonClient.post((HttpEntity)new StringEntity(query, ContentType.create((String)"text/plain", (String)"UTF-8")), "/api/search/aql", new Object[0]);
    }

    @Override
    public List<String> getBuildNames() {
        JsonNode node = this.jsonClient.get("/api/build", new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        node.path("builds").forEach(numberNode -> {
            String name = StringUtils.stripStart((String)numberNode.path("uri").asText(), (String)"/");
            if (StringUtils.isNotBlank((CharSequence)name)) {
                names.add(name);
            }
        });
        return names;
    }

    @Override
    public List<String> getBuildNumbers(String buildName) {
        try {
            JsonNode node = this.jsonClient.get("/api/build/%s", new Object[]{buildName});
            ArrayList<String> numbers = new ArrayList<String>();
            node.path("buildsNumbers").forEach(numberNode -> {
                String number = StringUtils.stripStart((String)numberNode.path("uri").asText(), (String)"/");
                if (StringUtils.isNotBlank((CharSequence)number)) {
                    numbers.add(number);
                }
            });
            return numbers;
        }
        catch (ClientNotFoundException ex) {
            return Collections.emptyList();
        }
    }

    @Override
    public JsonNode getBuildInfo(String buildName, String buildNumber) {
        return this.jsonClient.get("/api/build/%s/%s", new Object[]{buildName, buildNumber}).path("buildInfo");
    }

    @Override
    public List<ArtifactoryStatus> getStatuses(JsonNode buildInfo) {
        ArrayList<ArtifactoryStatus> statuses = new ArrayList<ArtifactoryStatus>();
        buildInfo.path("statuses").forEach(statusNode -> statuses.add(new ArtifactoryStatus(statusNode.path("status").asText(), statusNode.path("user").asText(), LocalDateTime.parse(statusNode.path("timestamp").asText(), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ")))));
        return statuses;
    }
}

