/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.artifactory;

import java.net.URI;
import java.util.Collection;
import net.nemerosa.ontrack.extension.artifactory.ArtifactoryExtensionFeature;
import net.nemerosa.ontrack.extension.artifactory.configuration.ArtifactoryConfiguration;
import net.nemerosa.ontrack.extension.artifactory.configuration.ArtifactoryConfigurationService;
import net.nemerosa.ontrack.extension.support.AbstractExtensionController;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.extension.ExtensionFeatureDescription;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.ConnectionResult;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RequestMapping(value={"extension/artifactory"})
@RestController
public class ArtifactoryController
extends AbstractExtensionController<ArtifactoryExtensionFeature> {
    private final ArtifactoryConfigurationService configurationService;
    private final SecurityService securityService;

    @Autowired
    public ArtifactoryController(ArtifactoryExtensionFeature feature, ArtifactoryConfigurationService configurationService, SecurityService securityService) {
        super((ExtensionFeature)feature);
        this.configurationService = configurationService;
        this.securityService = securityService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Resource<ExtensionFeatureDescription> getDescription() {
        return (Resource)Resource.of((Object)((ArtifactoryExtensionFeature)this.feature).getFeatureDescription(), (URI)this.uri(((ArtifactoryController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getDescription())).with("configurations", this.uri(((ArtifactoryController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurations()), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations"}, method={RequestMethod.GET})
    public Resources<ArtifactoryConfiguration> getConfigurations() {
        return (Resources)((Resources)Resources.of((Collection)this.configurationService.getConfigurations(), (URI)this.uri(((ArtifactoryController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurations())).with("_create", this.uri(((ArtifactoryController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationForm()))).with("_test", this.uri(((ArtifactoryController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).testConfiguration(null)), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations/descriptors"}, method={RequestMethod.GET})
    public Resources<ConfigurationDescriptor> getConfigurationsDescriptors() {
        return Resources.of((Collection)this.configurationService.getConfigurationDescriptors(), (URI)this.uri(((ArtifactoryController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationsDescriptors()));
    }

    @RequestMapping(value={"configurations/test"}, method={RequestMethod.POST})
    public ConnectionResult testConfiguration(@RequestBody ArtifactoryConfiguration configuration) {
        return this.configurationService.test(configuration);
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.GET})
    public Form getConfigurationForm() {
        return ArtifactoryConfiguration.form();
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.POST})
    public ArtifactoryConfiguration newConfiguration(@RequestBody ArtifactoryConfiguration configuration) {
        return (ArtifactoryConfiguration)this.configurationService.newConfiguration(configuration);
    }

    @RequestMapping(value={"configurations/{name}"}, method={RequestMethod.GET})
    public ArtifactoryConfiguration getConfiguration(@PathVariable String name) {
        return (ArtifactoryConfiguration)this.configurationService.getConfiguration(name);
    }

    @RequestMapping(value={"configurations/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Ack deleteConfiguration(@PathVariable String name) {
        this.configurationService.deleteConfiguration(name);
        return Ack.OK;
    }

    @RequestMapping(value={"configurations/{name}/update"}, method={RequestMethod.GET})
    public Form updateConfigurationForm(@PathVariable String name) {
        return ((ArtifactoryConfiguration)this.configurationService.getConfiguration(name)).asForm();
    }

    @RequestMapping(value={"configurations/{name}/update"}, method={RequestMethod.PUT})
    public ArtifactoryConfiguration updateConfiguration(@PathVariable String name, @RequestBody ArtifactoryConfiguration configuration) {
        this.configurationService.updateConfiguration(name, configuration);
        return this.getConfiguration(name);
    }
}

