/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.api.model;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import net.nemerosa.ontrack.extension.api.model.ExportRequestGroupingFormatException;
import net.nemerosa.ontrack.extension.api.model.IssueChangeLogExportRequest;
import org.junit.Assert;
import org.junit.Test;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007\u00a8\u0006\u000f"}, d2={"Lnet/nemerosa/ontrack/extension/api/model/IssueChangeLogExportRequestTest;", "", "()V", "empty", "", "getExcludedTypes_blank", "getExcludedTypes_empty", "getExcludedTypes_one", "getExcludedTypes_one_trimmed", "getExcludedTypes_several", "getExcludedTypes_several_trimmed", "group_format_exception_equal_sign", "one_group", "one_group_with_several_values", "two_groups", "ontrack-extension-api"})
public final class IssueChangeLogExportRequestTest {
    @Test
    public final void empty() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        Map spec = request.getGroupingSpecification();
        Assert.assertTrue((boolean)spec.isEmpty());
    }

    @Test
    public final void one_group() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setGrouping("Bugs=bug");
        Map spec = request.getGroupingSpecification();
        Assert.assertEquals((long)1L, (long)spec.size());
        Assert.assertEquals((Object)SetsKt.setOf((Object)"bug"), spec.get("Bugs"));
    }

    @Test
    public final void one_group_with_several_values() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setGrouping("Features=feature,enhancement");
        Map spec = request.getGroupingSpecification();
        Assert.assertEquals((long)1L, (long)spec.size());
        Assert.assertEquals((Object)SetsKt.setOf((Object[])new String[]{"feature", "enhancement"}), spec.get("Features"));
    }

    @Test
    public final void two_groups() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setGrouping("Bugs=bug|Features=feature,enhancement");
        Map spec = request.getGroupingSpecification();
        Assert.assertEquals((long)2L, (long)spec.size());
        Assert.assertEquals((Object)SetsKt.setOf((Object)"bug"), spec.get("Bugs"));
        Assert.assertEquals((Object)SetsKt.setOf((Object[])new String[]{"feature", "enhancement"}), spec.get("Features"));
    }

    @Test(expected=ExportRequestGroupingFormatException.class)
    public final void group_format_exception_equal_sign() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setGrouping("Bugs=bug=test");
        request.getGroupingSpecification();
    }

    @Test
    public final void getExcludedTypes_empty() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setExclude("");
        Assert.assertTrue((boolean)request.getExcludedTypes().isEmpty());
    }

    @Test
    public final void getExcludedTypes_blank() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setExclude("  ");
        Assert.assertTrue((boolean)request.getExcludedTypes().isEmpty());
    }

    @Test
    public final void getExcludedTypes_one() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setExclude("type1");
        Assert.assertEquals((Object)SetsKt.setOf((Object)"type1"), (Object)request.getExcludedTypes());
    }

    @Test
    public final void getExcludedTypes_one_trimmed() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setExclude(" type1  ");
        Assert.assertEquals((Object)SetsKt.setOf((Object)"type1"), (Object)request.getExcludedTypes());
    }

    @Test
    public final void getExcludedTypes_several() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setExclude("type1,type2,type3");
        Assert.assertEquals((Object)SetsKt.setOf((Object[])new String[]{"type1", "type2", "type3"}), (Object)request.getExcludedTypes());
    }

    @Test
    public final void getExcludedTypes_several_trimmed() {
        IssueChangeLogExportRequest request = new IssueChangeLogExportRequest();
        request.setExclude(" type1  ,  type2 ,    type3   ");
        Assert.assertEquals((Object)SetsKt.setOf((Object[])new String[]{"type1", "type2", "type3"}), (Object)request.getExcludedTypes());
    }
}

