/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.support;

import com.fasterxml.jackson.databind.JsonNode;
import net.nemerosa.ontrack.json.JsonParseException;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.exceptions.PropertyTypeStorageReadException;
import net.nemerosa.ontrack.model.exceptions.PropertyValidationException;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyType;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPropertyType<T>
implements PropertyType<T> {
    private final ExtensionFeature extensionFeature;

    protected AbstractPropertyType(ExtensionFeature extensionFeature) {
        this.extensionFeature = extensionFeature;
    }

    public ExtensionFeature getFeature() {
        return this.extensionFeature;
    }

    public Property<T> of(T value) {
        return Property.of((PropertyType)this, value);
    }

    public JsonNode forStorage(T value) {
        return AbstractPropertyType.format(value);
    }

    protected static <V> V parse(JsonNode node, Class<V> type) {
        try {
            return (V)JsonUtils.parse((JsonNode)node, type);
        }
        catch (JsonParseException e) {
            throw new PropertyTypeStorageReadException(type, (Exception)((Object)e));
        }
    }

    protected static JsonNode format(Object value) {
        return JsonUtils.format((Object)value);
    }

    protected void validateNotBlank(String value, String message) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new PropertyValidationException(message);
        }
    }
}

