/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.support;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.events.EventFactory;
import net.nemerosa.ontrack.model.events.EventPostService;
import net.nemerosa.ontrack.model.security.EncryptionService;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.Configuration;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.ConfigurationNotFoundException;
import net.nemerosa.ontrack.model.support.ConfigurationRepository;
import net.nemerosa.ontrack.model.support.ConfigurationService;
import net.nemerosa.ontrack.model.support.ConfigurationServiceListener;
import net.nemerosa.ontrack.model.support.ConfigurationValidationException;
import net.nemerosa.ontrack.model.support.ConnectionResult;
import net.nemerosa.ontrack.model.support.OntrackConfigProperties;
import net.nemerosa.ontrack.model.support.UserPasswordConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class AbstractConfigurationService<T extends UserPasswordConfiguration<T>>
implements ConfigurationService<T> {
    private final Class<T> configurationClass;
    private final ConfigurationRepository configurationRepository;
    private final SecurityService securityService;
    private final EncryptionService encryptionService;
    private final EventPostService eventPostService;
    private final EventFactory eventFactory;
    private final OntrackConfigProperties ontrackConfigProperties;
    private final List<ConfigurationServiceListener<T>> listeners = new LinkedList<ConfigurationServiceListener<T>>();

    public AbstractConfigurationService(Class<T> configurationClass, ConfigurationRepository configurationRepository, SecurityService securityService, EncryptionService encryptionService, EventPostService eventPostService, EventFactory eventFactory, OntrackConfigProperties ontrackConfigProperties) {
        this.configurationClass = configurationClass;
        this.configurationRepository = configurationRepository;
        this.securityService = securityService;
        this.encryptionService = encryptionService;
        this.eventPostService = eventPostService;
        this.eventFactory = eventFactory;
        this.ontrackConfigProperties = ontrackConfigProperties;
    }

    protected void checkAccess() {
        this.securityService.checkGlobalFunction(GlobalSettings.class);
    }

    public List<T> getConfigurations() {
        return this.configurationRepository.list(this.configurationClass).stream().map(this::decrypt).collect(Collectors.toList());
    }

    public List<ConfigurationDescriptor> getConfigurationDescriptors() {
        return (List)this.securityService.runAsAdmin(() -> this.getConfigurations().stream().map(Configuration::getDescriptor).collect(Collectors.toList())).get();
    }

    public T newConfiguration(T configuration) {
        this.checkAccess();
        this.validateAndCheck(configuration);
        this.configurationRepository.save(this.encrypt(configuration));
        this.eventPostService.post(this.eventFactory.newConfiguration(configuration));
        this.listeners.forEach(listener -> listener.onNewConfiguration(configuration));
        return (T)((UserPasswordConfiguration)configuration.obfuscate());
    }

    public T getConfiguration(String name) {
        return (T)((UserPasswordConfiguration)this.findConfiguration(name).orElseThrow(() -> new ConfigurationNotFoundException(name)));
    }

    protected Optional<T> findConfiguration(String name) {
        return this.configurationRepository.find(this.configurationClass, name).map(this::decrypt);
    }

    public Optional<T> getOptionalConfiguration(String name) {
        return this.configurationRepository.find(this.configurationClass, name).map(this::decrypt);
    }

    public void deleteConfiguration(String name) {
        this.checkAccess();
        Object configuration = this.getConfiguration(name);
        this.eventPostService.post(this.eventFactory.deleteConfiguration(configuration));
        this.listeners.forEach(listener -> listener.onDeletedConfiguration(configuration));
        this.configurationRepository.delete(this.configurationClass, name);
    }

    public void updateConfiguration(String name, T configuration) {
        this.checkAccess();
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)name, (CharSequence)configuration.getName()), (String)"Configuration name must match", (Object[])new Object[0]);
        T configToSave = this.injectCredentials(configuration);
        this.validateAndCheck(configToSave);
        this.configurationRepository.save(this.encrypt(configToSave));
        this.eventPostService.post(this.eventFactory.updateConfiguration(configuration));
        this.listeners.forEach(listener -> listener.onUpdatedConfiguration(configuration));
    }

    protected T injectCredentials(T configuration) {
        UserPasswordConfiguration oldConfig = this.findConfiguration(configuration.getName()).orElse(null);
        Object target = StringUtils.isBlank((CharSequence)configuration.getPassword()) ? (oldConfig != null && StringUtils.equals((CharSequence)oldConfig.getUser(), (CharSequence)configuration.getUser()) ? configuration.withPassword(oldConfig.getPassword()) : configuration) : configuration;
        return target;
    }

    protected void validateAndCheck(T configuration) {
        ConnectionResult result;
        if (this.ontrackConfigProperties.getConfigurationTest() && (result = this.validate(configuration)).getType() == ConnectionResult.ConnectionResultType.ERROR) {
            throw new ConfigurationValidationException(configuration, result.getMessage());
        }
    }

    public ConnectionResult test(T configuration) {
        return this.validate(this.injectCredentials(configuration));
    }

    protected abstract ConnectionResult validate(T var1);

    public T replaceConfiguration(T configuration, Function<String, String> replacementFunction) throws ConfigurationNotFoundException {
        String targetConfigurationName;
        String sourceConfigurationName = configuration.getName();
        if (StringUtils.equals((CharSequence)sourceConfigurationName, (CharSequence)(targetConfigurationName = replacementFunction.apply(sourceConfigurationName)))) {
            return configuration;
        }
        if (!this.securityService.isGlobalFunctionGranted(GlobalSettings.class)) {
            throw new ConfigurationNotFoundException(targetConfigurationName);
        }
        UserPasswordConfiguration targetConfiguration = configuration.clone(targetConfigurationName, replacementFunction);
        return (T)this.newConfiguration(targetConfiguration);
    }

    public Class<T> getConfigurationType() {
        return this.configurationClass;
    }

    protected T encrypt(T config) {
        return (T)config.withPassword(this.encryptionService.encrypt(config.getPassword()));
    }

    public void addConfigurationServiceListener(ConfigurationServiceListener<T> listener) {
        this.listeners.add(listener);
    }

    protected T decrypt(T config) {
        return (T)config.withPassword(this.encryptionService.decrypt(config.getPassword()));
    }
}

