/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.api.support;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.api.support.TestExtensionFeature;
import net.nemerosa.ontrack.extension.api.support.TestSimpleProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectEdit;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertySearchArguments;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSimplePropertyType
extends AbstractPropertyType<TestSimpleProperty> {
    @Autowired
    public TestSimplePropertyType(TestExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "Simple value";
    }

    public String getDescription() {
        return "Value.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.allOf(ProjectEntityType.class);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectEdit.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, TestSimpleProperty value) {
        return Form.create().with((Field)((Text)Text.of((String)"value").label("Value")).value((Object)(value != null ? value.getValue() : "")));
    }

    public TestSimpleProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public TestSimpleProperty fromStorage(JsonNode node) {
        return (TestSimpleProperty)TestSimplePropertyType.parse((JsonNode)node, TestSimpleProperty.class);
    }

    public String getSearchKey(TestSimpleProperty value) {
        return value.getValue();
    }

    public TestSimpleProperty replaceValue(TestSimpleProperty value, Function<String, String> replacementFunction) {
        return new TestSimpleProperty(replacementFunction.apply(value.getValue()));
    }

    @Nullable
    public PropertySearchArguments getSearchArguments(String token) {
        return new PropertySearchArguments(null, "pp.json->>'value' like :value", Collections.singletonMap("value", "%" + token + "%"));
    }

    public boolean containsValue(TestSimpleProperty value, String propertyValue) {
        return StringUtils.containsIgnoreCase((CharSequence)value.getValue(), (CharSequence)propertyValue);
    }
}

