/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.api.support;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.api.support.TestDecorationData;
import net.nemerosa.ontrack.extension.api.support.TestExtensionFeature;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.security.ProjectEdit;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestDecoratorPropertyType
extends AbstractPropertyType<TestDecorationData> {
    @Autowired
    public TestDecoratorPropertyType(TestExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "Decorator value";
    }

    public String getDescription() {
        return "Value.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.allOf(ProjectEntityType.class);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectEdit.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, TestDecorationData value) {
        return Form.create().with((Field)((Text)Text.of((String)"value").label("Value")).value((Object)(value != null ? value.getValue() : ""))).with((Field)((YesNo)YesNo.of((String)"valid").label("Valid")).value((Object)(value != null && value.isValid() ? 1 : 0)));
    }

    public TestDecorationData fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public TestDecorationData fromStorage(JsonNode node) {
        return (TestDecorationData)TestDecoratorPropertyType.parse((JsonNode)node, TestDecorationData.class);
    }

    public String getSearchKey(TestDecorationData value) {
        return value.getValue();
    }

    public TestDecorationData replaceValue(TestDecorationData value, Function<String, String> replacementFunction) {
        return new TestDecorationData(replacementFunction.apply(value.getValue()), value.isValid());
    }
}

