/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.api.support;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.nemerosa.ontrack.extension.api.DecorationExtension;
import net.nemerosa.ontrack.extension.api.support.TestDecorationData;
import net.nemerosa.ontrack.extension.api.support.TestDecoratorPropertyType;
import net.nemerosa.ontrack.extension.api.support.TestExtensionFeature;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.Decorator;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestDecorator
extends AbstractExtension
implements DecorationExtension<TestDecorationData> {
    private final PropertyService propertyService;

    @Autowired
    public TestDecorator(TestExtensionFeature extensionFeature, PropertyService propertyService) {
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
    }

    public List<Decoration<TestDecorationData>> getDecorations(ProjectEntity entity) {
        return this.propertyService.getProperty(entity, TestDecoratorPropertyType.class).option().map(data -> Collections.singletonList(Decoration.of((Decorator)this, (Object)data))).orElse(Collections.emptyList());
    }

    public EnumSet<ProjectEntityType> getScope() {
        return EnumSet.allOf(ProjectEntityType.class);
    }
}

