/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.api.support;

import java.beans.ConstructorProperties;
import java.util.function.Function;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.UserPasswordConfiguration;

public class TestConfiguration
implements UserPasswordConfiguration<TestConfiguration> {
    private final String name;
    private final String user;
    private final String password;
    public static final String PLAIN_PASSWORD = "verysecret";

    public TestConfiguration withPassword(String password) {
        return new TestConfiguration(this.name, this.user, password);
    }

    public TestConfiguration clone(String targetConfigurationName, Function<String, String> replacementFunction) {
        return new TestConfiguration(targetConfigurationName, this.user, this.password);
    }

    public ConfigurationDescriptor getDescriptor() {
        return new ConfigurationDescriptor("test", this.name);
    }

    public TestConfiguration obfuscate() {
        return new TestConfiguration(this.name, this.user, "");
    }

    public static TestConfiguration config(String name) {
        return new TestConfiguration(name, "user", PLAIN_PASSWORD);
    }

    @ConstructorProperties(value={"name", "user", "password"})
    public TestConfiguration(String name, String user, String password) {
        this.name = name;
        this.user = user;
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestConfiguration)) {
            return false;
        }
        TestConfiguration other = (TestConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "TestConfiguration(name=" + this.getName() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ")";
    }
}

