/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.api.support;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.api.support.TestConfiguration;
import net.nemerosa.ontrack.extension.api.support.TestExtensionFeature;
import net.nemerosa.ontrack.extension.api.support.TestProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectEdit;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.support.ConfigurationPropertyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestPropertyType
extends AbstractPropertyType<TestProperty>
implements ConfigurationPropertyType<TestConfiguration, TestProperty> {
    @Autowired
    public TestPropertyType(TestExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "Configuration value";
    }

    public String getDescription() {
        return "Value.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.allOf(ProjectEntityType.class);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectEdit.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, TestProperty value) {
        return Form.create().with((Field)((Text)Text.of((String)"value").label("Value")).value((Object)(value != null ? value.getValue() : "")));
    }

    public TestProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public TestProperty fromStorage(JsonNode node) {
        return (TestProperty)TestPropertyType.parse((JsonNode)node, TestProperty.class);
    }

    public String getSearchKey(TestProperty value) {
        return value.getValue();
    }

    public TestProperty replaceValue(TestProperty value, Function<String, String> replacementFunction) {
        return new TestProperty((TestConfiguration)value.getConfiguration().clone(replacementFunction.apply(value.getConfiguration().getName()), (Function)replacementFunction), replacementFunction.apply(value.getValue()));
    }
}

