/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.docs;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.docs.DSLDoc;
import net.nemerosa.ontrack.docs.DSLDocClass;
import net.nemerosa.ontrack.docs.DSLDocMethod;
import org.apache.commons.lang3.StringUtils;

public class AsciiDocGenerator {
    public void generate(File dir, DSLDoc doc) throws IOException, ClassNotFoundException {
        File indexFile = new File(dir, "dsl-index.adoc");
        System.out.format("[doc] Writing index %s%n", indexFile.getName());
        try (PrintWriter writer = new PrintWriter(indexFile);){
            this.adocIndex(writer, doc);
        }
        doc.getClasses().values().stream().filter(dslDocClass -> !dslDocClass.isPropertyClass()).forEach(dslDocClass -> this.adocClass(dir, dslDocClass));
    }

    private void adocClass(File dir, DSLDocClass docClass) {
        File clsFile = new File(dir, String.format("dsl-%s.adoc", docClass.getId()));
        System.out.format("[doc] Writing class %s in %s%n", docClass.getName(), clsFile.getName());
        try (PrintWriter writer = new PrintWriter(clsFile);){
            this.adocClass(writer, docClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void adocIndex(PrintWriter writer, DSLDoc doc) throws IOException, ClassNotFoundException {
        writer.format("%n|===%n", new Object[0]);
        writer.format("3+| Class summary%n", new Object[0]);
        writer.format("h| Class | |%n%n", new Object[0]);
        writer.format("| <<dsl-ontrack,Ontrack>> | - | <<dsl-ontrack-methods,Methods>> %n%n", new Object[0]);
        doc.getClasses().values().stream().filter(c -> !StringUtils.equals((CharSequence)"ontrack", (CharSequence)c.getId())).filter(c -> !c.isPropertyClass()).sorted(Comparator.comparing(DSLDocClass::getName)).forEach(docClass -> writer.format("| <<dsl-%s,%s>> | %s | %s%n%n", docClass.getId(), docClass.getName(), docClass.getProperties().get() != null ? String.format("<<dsl-%s-properties,Properties>>", docClass.getId()) : "", docClass.getMethods().isEmpty() ? "" : String.format("<<dsl-%s-methods,Methods>>", docClass.getId())));
        writer.format("%n|===%n", new Object[0]);
        writer.format("include::dsl-ontrack.adoc[]%n%n", new Object[0]);
        doc.getClasses().values().stream().filter(c -> !StringUtils.equals((CharSequence)"ontrack", (CharSequence)c.getId())).filter(c -> !c.isPropertyClass()).sorted(Comparator.comparing(DSLDocClass::getName)).forEach(docClass -> writer.format("include::dsl-%s.adoc[]%n%n", docClass.getId()));
    }

    private void adocClass(PrintWriter writer, DSLDocClass docClass) {
        writer.format("[[dsl-%s]]%n", docClass.getId());
        writer.format("==== %s%n", docClass.getName());
        if (StringUtils.isNotBlank((CharSequence)docClass.getDescription())) {
            writer.format("%n%s%n", docClass.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)docClass.getLongDescription())) {
            writer.format("%n%s%n", docClass.getLongDescription());
        }
        if (!docClass.getReferences().isEmpty()) {
            writer.format("%nSee also: %s%n", docClass.getReferences().stream().map(AsciiDocGenerator::getRefLink).collect(Collectors.joining(", ")));
        }
        this.adocSample(writer, docClass.getSample());
        DSLDocClass propertyClass = (DSLDocClass)docClass.getProperties().get();
        if (propertyClass != null) {
            writer.format("%nGo to the <<dsl-%s-methods,methods>>%n", docClass.getId());
            this.adocPropertyClass(writer, docClass, propertyClass);
        }
        if (!docClass.getMethods().isEmpty()) {
            writer.format("[[dsl-%s-methods]]%n", docClass.getId());
            writer.format("|===%n", new Object[0]);
            writer.format("2+h| Method summary%n", new Object[0]);
            writer.format("| Method | Description%n%n", new Object[0]);
            docClass.getMethods().stream().sorted(Comparator.comparing(DSLDocMethod::getName)).forEach(dslDocMethod -> writer.format("| <<dsl-%s-%s,`%s`>> | `%s`%n%n%s%n%n", docClass.getId(), dslDocMethod.getId(), dslDocMethod.getName(), dslDocMethod.getSignature(), this.safe(dslDocMethod.getDescription())));
            writer.format("|===%n", new Object[0]);
            docClass.getMethods().stream().sorted(Comparator.comparing(DSLDocMethod::getName)).forEach(dslDocMethod -> this.adocMethod(writer, docClass, dslDocMethod, false));
        }
        writer.println();
    }

    private void adocPropertyClass(PrintWriter writer, DSLDocClass docClass, DSLDocClass propertyClass) {
        writer.format("[[dsl-%s-properties]]%n", docClass.getId());
        writer.format("|===%n", new Object[0]);
        writer.format("2+h| Configuration properties%n", new Object[0]);
        writer.format("2+a| %s%n%n%s%n%n", this.safe(propertyClass.getDescription()), this.safe(propertyClass.getLongDescription()));
        if (!propertyClass.getReferences().isEmpty()) {
            writer.format("%nSee also: %s%n", propertyClass.getReferences().stream().map(AsciiDocGenerator::getRefLink).collect(Collectors.joining(", ")));
        }
        this.adocSample(writer, propertyClass.getSample());
        writer.format("2+h| Configuration property summary%n", new Object[0]);
        writer.format("| Property | Description%n%n", new Object[0]);
        propertyClass.getMethods().stream().sorted(Comparator.comparing(DSLDocMethod::getName)).forEach(dslDocMethod -> writer.format("| <<dsl-%s-%s,`%s`>> | `%s`%n%n%s%n%n", propertyClass.getId(), dslDocMethod.getId(), dslDocMethod.getName(), dslDocMethod.getSignature(), this.safe(dslDocMethod.getDescription())));
        writer.format("|===%n", new Object[0]);
        propertyClass.getMethods().forEach(dslDocMethod -> this.adocMethod(writer, propertyClass, dslDocMethod, true));
        writer.println();
    }

    private void adocSample(PrintWriter writer, String sample) {
        if (StringUtils.isNotBlank((CharSequence)sample)) {
            writer.format("%nSample:%n", new Object[0]);
            writer.format("%n[source,groovy]%n", new Object[0]);
            writer.format("----%n", new Object[0]);
            writer.println(sample);
            writer.format("----%n", new Object[0]);
        }
    }

    private void adocMethod(PrintWriter writer, DSLDocClass docClass, DSLDocMethod docMethod, boolean property) {
        writer.format("%n[[dsl-%s-%s]]%n", docClass.getId(), docMethod.getId());
        writer.format("|===%n", new Object[0]);
        writer.format("| %s%s%n%n", property ? "Configuration: " : "", docMethod.getName());
        writer.format("a| `%s`%n%n%s%n%n", docMethod.getSignature(), this.safe(docMethod.getDescription()));
        writer.format("%n", new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)docMethod.getSee())) {
            DSLDocMethod targetMethod = docClass.getMethods().stream().filter(m -> StringUtils.equals((CharSequence)docMethod.getSee(), (CharSequence)m.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find method with ID <%s> in class <%s>", docMethod.getSee(), docClass.getName())));
            writer.format("%nSee <<dsl-%s-%s,%s>>%n", docClass.getId(), docMethod.getSee(), targetMethod.getName());
        }
        if (!docMethod.getReferences().isEmpty()) {
            writer.format("%nSee: %s%n", docMethod.getReferences().stream().map(AsciiDocGenerator::getRefLink).collect(Collectors.joining(", ")));
        }
        writer.format("%s%n%n", this.safe(docMethod.getLongDescription()));
        this.adocSample(writer, docMethod.getSample());
        writer.format("|===%n%n", new Object[0]);
    }

    private String safe(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? value : "";
    }

    private static String getRefLink(DSLDocClass ref) {
        return String.format("<<dsl-%s,%s>>", ref.getId(), ref.getName());
    }
}

