/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.common;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import net.nemerosa.ontrack.common.RGBColorException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0000J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001a"}, d2={"Lnet/nemerosa/ontrack/common/RGBColor;", "", "red", "", "green", "blue", "(III)V", "getBlue", "()I", "getGreen", "getRed", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toBlackOrWhite", "toString", "", "validateComponent", "", "component", "Companion", "ontrack-common"})
public final class RGBColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int red;
    private final int green;
    private final int blue;
    @NotNull
    private static final Regex regex = new Regex("#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})");
    @NotNull
    private static final RGBColor BLACK = new RGBColor(0, 0, 0);
    @NotNull
    private static final RGBColor WHITE = new RGBColor(255, 255, 255);

    public RGBColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.validateComponent(this.red);
        this.validateComponent(this.green);
        this.validateComponent(this.blue);
    }

    public final int getRed() {
        return this.red;
    }

    public final int getGreen() {
        return this.green;
    }

    public final int getBlue() {
        return this.blue;
    }

    private final void validateComponent(int component) {
        if (component < 0) {
            throw new RGBColorException("Color component must be >= 0");
        }
        if (component > 255) {
            throw new RGBColorException("Color component must be <= 255");
        }
    }

    @NotNull
    public final RGBColor toBlackOrWhite() {
        double r = (double)this.red / 255.0;
        double g = (double)this.green / 255.0;
        double b = (double)this.blue / 255.0;
        double min = Math.min(r, Math.min(g, b));
        double max = Math.max(r, Math.max(g, b));
        double l = (min + max) / (double)2;
        return l <= 0.75 ? WHITE : BLACK;
    }

    @NotNull
    public String toString() {
        return "#" + RGBColor.Companion.toHex(this.red) + RGBColor.Companion.toHex(this.green) + RGBColor.Companion.toHex(this.blue);
    }

    public final int component1() {
        return this.red;
    }

    public final int component2() {
        return this.green;
    }

    public final int component3() {
        return this.blue;
    }

    @NotNull
    public final RGBColor copy(int red, int green, int blue) {
        return new RGBColor(red, green, blue);
    }

    public static /* synthetic */ RGBColor copy$default(RGBColor rGBColor, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = rGBColor.red;
        }
        if ((n4 & 2) != 0) {
            n2 = rGBColor.green;
        }
        if ((n4 & 4) != 0) {
            n3 = rGBColor.blue;
        }
        return rGBColor.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.red);
        result = result * 31 + Integer.hashCode(this.green);
        result = result * 31 + Integer.hashCode(this.blue);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RGBColor)) {
            return false;
        }
        RGBColor rGBColor = (RGBColor)other;
        if (this.red != rGBColor.red) {
            return false;
        }
        if (this.green != rGBColor.green) {
            return false;
        }
        return this.blue == rGBColor.blue;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/nemerosa/ontrack/common/RGBColor$Companion;", "", "()V", "BLACK", "Lnet/nemerosa/ontrack/common/RGBColor;", "getBLACK", "()Lnet/nemerosa/ontrack/common/RGBColor;", "WHITE", "getWHITE", "regex", "Lkotlin/text/Regex;", "fromHex", "", "hex", "", "parse", "text", "toHex", "component", "ontrack-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RGBColor getBLACK() {
            return BLACK;
        }

        @NotNull
        public final RGBColor getWHITE() {
            return WHITE;
        }

        @NotNull
        public final RGBColor parse(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            MatchResult matchResult = regex.matchEntire((CharSequence)text);
            if (matchResult != null) {
                MatchResult.Destructured destructured = matchResult.getDestructured();
                String hr = (String)destructured.getMatch().getGroupValues().get(1);
                String hg = (String)destructured.getMatch().getGroupValues().get(2);
                String hb = (String)destructured.getMatch().getGroupValues().get(3);
                int r = this.fromHex(hr);
                int g = this.fromHex(hg);
                int b = this.fromHex(hb);
                return new RGBColor(r, g, b);
            }
            throw new RGBColorException("Color format does not match: " + text);
        }

        private final int fromHex(String hex) {
            return Integer.parseInt(hex, CharsKt.checkRadix((int)16));
        }

        private final String toHex(int component) {
            String string = Integer.toString(component, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String h = string2;
            return component < 16 ? "0" + h : h;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

