/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.common;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lnet/nemerosa/ontrack/common/Document;", "", "type", "", "content", "", "(Ljava/lang/String;[B)V", "getContent", "()[B", "isEmpty", "", "()Z", "getType", "()Ljava/lang/String;", "equals", "other", "hashCode", "", "Companion", "ontrack-common"})
public class Document {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final byte[] content;
    @JvmField
    @NotNull
    public static final Document EMPTY = new Document("", new byte[0]);

    public Document(@NotNull String type, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.type = type;
        this.content = content;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final byte[] getContent() {
        return this.content;
    }

    public final boolean isEmpty() {
        return Intrinsics.areEqual((Object)"", (Object)this.type) || this.content.length == 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Document)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)((Document)other).type)) {
            return false;
        }
        return Arrays.equals(this.content, ((Document)other).content);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }

    @JvmStatic
    public static final boolean isValid(@Nullable Document document) {
        return Companion.isValid(document);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/nemerosa/ontrack/common/Document$Companion;", "", "()V", "EMPTY", "Lnet/nemerosa/ontrack/common/Document;", "isValid", "", "document", "ontrack-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isValid(@Nullable Document document) {
            return document != null && !document.isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

