/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.common;

import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.nemerosa.ontrack.common.TaskCancelledException;
import net.nemerosa.ontrack.common.TaskExecutionException;
import net.nemerosa.ontrack.common.TaskInterruptedException;
import net.nemerosa.ontrack.common.TaskNotScheduledException;
import net.nemerosa.ontrack.common.TaskTimeoutException;
import org.jetbrains.annotations.NotNull;

public abstract class FutureUtils {
    public static <T> T wait(String message, Optional<Future<? extends T>> task) {
        if (task.isPresent()) {
            return FutureUtils.wait(message, task.get());
        }
        throw new TaskNotScheduledException(message);
    }

    public static <T> T wait(String message, @NotNull Future<T> task) {
        return FutureUtils.wait(message, task, 300L);
    }

    public static <T> T wait(String message, @NotNull Future<T> task, long seconds) {
        try {
            return task.get(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new TaskInterruptedException(message);
        }
        catch (CancellationException e) {
            throw new TaskCancelledException(message);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new TaskExecutionException(message, cause);
        }
        catch (TimeoutException e) {
            throw new TaskTimeoutException(message, seconds);
        }
    }
}

