/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.common;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.common.Version;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lnet/nemerosa/ontrack/common/Version;", "", "major", "", "minor", "patch", "(III)V", "isValid", "", "()Z", "getMajor", "()I", "getMinor", "getPatch", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "", "Companion", "ontrack-common"})
public final class Version
implements Comparable<Version> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private static final Regex PATTERN = new Regex("^([\\d]+)(\\.([\\d]+)(\\.([\\d]+))?)?.*$");
    @NotNull
    private static final Version NONE = new Version(0, 0, 0, 7, null);

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public /* synthetic */ Version(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    public final boolean isValid() {
        return this.major >= 0 && this.minor >= 0 && this.patch >= 0 && (this.major > 0 || this.minor > 0 || this.patch > 0);
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE, compareTo.3.INSTANCE};
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
    }

    @NotNull
    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final Version copy(int major, int minor, int patch) {
        return new Version(major, minor, patch);
    }

    public static /* synthetic */ Version copy$default(Version version, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = version.major;
        }
        if ((n4 & 2) != 0) {
            n2 = version.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = version.patch;
        }
        return version.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version version = (Version)other;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        return this.patch == version.patch;
    }

    public Version() {
        this(0, 0, 0, 7, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/nemerosa/ontrack/common/Version$Companion;", "", "()V", "NONE", "Lnet/nemerosa/ontrack/common/Version;", "getNONE", "()Lnet/nemerosa/ontrack/common/Version;", "PATTERN", "Lkotlin/text/Regex;", "parse", "", "value", "", "parseVersion", "ontrack-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getNONE() {
            return NONE;
        }

        @Nullable
        public final Version parseVersion(@Nullable String value) {
            if (value != null && !StringsKt.isBlank((CharSequence)value)) {
                Version version;
                MatchResult matcher = PATTERN.matchEntire((CharSequence)value);
                if (matcher != null) {
                    String majorValue = (String)matcher.getGroupValues().get(1);
                    String minorValue = (String)matcher.getGroupValues().get(3);
                    String patchValue = (String)matcher.getGroupValues().get(5);
                    int major = this.parse(majorValue);
                    int minor = this.parse(minorValue);
                    int patch = this.parse(patchValue);
                    version = new Version(major, minor, patch);
                } else {
                    version = null;
                }
                return version;
            }
            return null;
        }

        private final int parse(String value) {
            return StringsKt.isBlank((CharSequence)value) ? 0 : (StringUtils.isNumeric((CharSequence)value) ? Integer.parseInt(value, 10) : -1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

