/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.common;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u001e\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0007J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0007J\b\u0010\u0012\u001a\u00020\tH\u0007J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/nemerosa/ontrack/common/Time;", "", "()V", "DATE_TIME_STORAGE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "TIME_STORAGE_FORMAT", "forStorage", "", "time", "Ljava/time/LocalDateTime;", "from", "date", "Ljava/util/Date;", "defaultValue", "epochMillis", "", "fromStorage", "value", "now", "store", "toEpochMillis", "toLocalDateTime", "zonedDateTime", "Ljava/time/ZonedDateTime;", "truncate", "ontrack-common"})
public final class Time {
    @NotNull
    public static final Time INSTANCE = new Time();
    @NotNull
    private static final DateTimeFormatter TIME_STORAGE_FORMAT;
    @NotNull
    private static final DateTimeFormatter DATE_TIME_STORAGE_FORMAT;

    private Time() {
    }

    @NotNull
    public final LocalDateTime truncate(@NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        int nano = time.getNano();
        LocalDateTime base = time.truncatedTo(ChronoUnit.SECONDS);
        int truncatedNano = nano / 100000 * 100000;
        LocalDateTime localDateTime = base.with(ChronoField.NANO_OF_SECOND, truncatedNano);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"base.with(ChronoField.NA\u2026, truncatedNano.toLong())");
        return localDateTime;
    }

    @JvmStatic
    @NotNull
    public static final LocalDateTime now() {
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(ZoneOffset.UTC)");
        return localDateTime;
    }

    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull ZonedDateTime zonedDateTime) {
        Intrinsics.checkNotNullParameter((Object)zonedDateTime, (String)"zonedDateTime");
        LocalDateTime localDateTime = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"zonedDateTime.withZoneSa\u2026et.UTC).toLocalDateTime()");
        return localDateTime;
    }

    @Deprecated(message="Use store instead and null-proof operators.", replaceWith=@ReplaceWith(expression="store", imports={}))
    @JvmStatic
    @Nullable
    public static final String forStorage(@Nullable LocalDateTime time) {
        LocalDateTime localDateTime = time;
        return localDateTime == null ? null : localDateTime.format(DATE_TIME_STORAGE_FORMAT);
    }

    @NotNull
    public final String store(@NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = time.format(DATE_TIME_STORAGE_FORMAT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"time.format(DATE_TIME_STORAGE_FORMAT)");
        return string;
    }

    @JvmStatic
    @Nullable
    public static final LocalDateTime fromStorage(@Nullable String value) {
        CharSequence charSequence = value;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? (LocalDateTime)null : LocalDateTime.parse(value, DATE_TIME_STORAGE_FORMAT.withZone(ZoneOffset.UTC));
    }

    @JvmStatic
    @Nullable
    public static final LocalDateTime from(@Nullable Date date, @Nullable LocalDateTime defaultValue) {
        return date != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneOffset.UTC) : defaultValue;
    }

    @NotNull
    public final LocalDateTime from(long epochMillis) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(Instant.ofEpoc\u2026hMillis), ZoneOffset.UTC)");
        return localDateTime;
    }

    public final long toEpochMillis(@NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return time.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    static {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 4, true).toFormatter(Locale.ENGLISH);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"DateTimeFormatterBuilder\u2026Formatter(Locale.ENGLISH)");
        TIME_STORAGE_FORMAT = dateTimeFormatter;
        dateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(TIME_STORAGE_FORMAT).toFormatter(Locale.ENGLISH);
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"DateTimeFormatterBuilder\u2026Formatter(Locale.ENGLISH)");
        DATE_TIME_STORAGE_FORMAT = dateTimeFormatter;
    }
}

