/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.common;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import net.nemerosa.ontrack.common.RGBColorException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0000J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001a"}, d2={"Lnet/nemerosa/ontrack/common/RGBColor;", "", "red", "", "green", "blue", "(III)V", "getBlue", "()I", "getGreen", "getRed", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toBlackOrWhite", "toString", "", "validateComponent", "", "component", "Companion", "ontrack-common"})
public final class RGBColor {
    private final int red;
    private final int green;
    private final int blue;
    private static final Regex regex;
    @NotNull
    private static final RGBColor BLACK;
    @NotNull
    private static final RGBColor WHITE;
    @NotNull
    public static final Companion Companion;

    private final void validateComponent(int component) {
        if (component < 0) {
            throw (Throwable)new RGBColorException("Color component must be >= 0");
        }
        if (component > 255) {
            throw (Throwable)new RGBColorException("Color component must be <= 255");
        }
    }

    @NotNull
    public final RGBColor toBlackOrWhite() {
        double r = (double)this.red / 255.0;
        double g = (double)this.green / 255.0;
        double b = (double)this.blue / 255.0;
        boolean bl = false;
        boolean bl2 = false;
        double d = Math.min(g, b);
        boolean bl3 = false;
        double min = Math.min(r, d);
        boolean bl4 = false;
        boolean bl5 = false;
        double d2 = Math.max(g, b);
        boolean bl6 = false;
        double max = Math.max(r, d2);
        double l = (min + max) / (double)2;
        return l <= 0.75 ? WHITE : BLACK;
    }

    @NotNull
    public String toString() {
        return '#' + RGBColor.Companion.toHex(this.red) + RGBColor.Companion.toHex(this.green) + RGBColor.Companion.toHex(this.blue);
    }

    public final int getRed() {
        return this.red;
    }

    public final int getGreen() {
        return this.green;
    }

    public final int getBlue() {
        return this.blue;
    }

    public RGBColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.validateComponent(this.red);
        this.validateComponent(this.green);
        this.validateComponent(this.blue);
    }

    static {
        Companion = new Companion(null);
        String string = "#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})";
        boolean bl = false;
        regex = new Regex(string);
        BLACK = new RGBColor(0, 0, 0);
        WHITE = new RGBColor(255, 255, 255);
    }

    public final int component1() {
        return this.red;
    }

    public final int component2() {
        return this.green;
    }

    public final int component3() {
        return this.blue;
    }

    @NotNull
    public final RGBColor copy(int red, int green, int blue) {
        return new RGBColor(red, green, blue);
    }

    public static /* synthetic */ RGBColor copy$default(RGBColor rGBColor, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = rGBColor.red;
        }
        if ((n4 & 2) != 0) {
            n2 = rGBColor.green;
        }
        if ((n4 & 4) != 0) {
            n3 = rGBColor.blue;
        }
        return rGBColor.copy(n, n2, n3);
    }

    public int hashCode() {
        return (Integer.hashCode(this.red) * 31 + Integer.hashCode(this.green)) * 31 + Integer.hashCode(this.blue);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RGBColor)) break block3;
                RGBColor rGBColor = (RGBColor)object;
                if (this.red != rGBColor.red || this.green != rGBColor.green || this.blue != rGBColor.blue) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/nemerosa/ontrack/common/RGBColor$Companion;", "", "()V", "BLACK", "Lnet/nemerosa/ontrack/common/RGBColor;", "getBLACK", "()Lnet/nemerosa/ontrack/common/RGBColor;", "WHITE", "getWHITE", "regex", "Lkotlin/text/Regex;", "fromHex", "", "hex", "", "parse", "text", "toHex", "component", "ontrack-common"})
    public static final class Companion {
        @NotNull
        public final RGBColor getBLACK() {
            return BLACK;
        }

        @NotNull
        public final RGBColor getWHITE() {
            return WHITE;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RGBColor parse(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            MatchResult matchResult = regex.matchEntire((CharSequence)text);
            if (matchResult != null) {
                void hg;
                void hr;
                MatchResult.Destructured destructured;
                MatchResult.Destructured destructured2 = destructured = matchResult.getDestructured();
                boolean bl = false;
                String string = (String)destructured2.getMatch().getGroupValues().get(1);
                destructured2 = destructured;
                bl = false;
                String string2 = (String)destructured2.getMatch().getGroupValues().get(2);
                destructured2 = destructured;
                bl = false;
                String hb = (String)destructured2.getMatch().getGroupValues().get(3);
                int r = this.fromHex((String)hr);
                int g = this.fromHex((String)hg);
                int b = this.fromHex(hb);
                return new RGBColor(r, g, b);
            }
            throw (Throwable)new RGBColorException("Color format does not match: " + text);
        }

        private final int fromHex(String hex) {
            String string = hex;
            int n = 16;
            boolean bl = false;
            return Integer.parseInt(string, CharsKt.checkRadix((int)n));
        }

        private final String toHex(int component) {
            int n = component;
            int n2 = 16;
            boolean bl = false;
            String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String string2 = string;
            n2 = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
            String h = string4;
            return component < 16 ? '0' + h : h;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

