/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.nemerosa.ontrack.common.ProcessExitException;
import net.nemerosa.ontrack.common.ProcessRunException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static boolean safeRegexMatch(String pattern, String value) {
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            if (value == null) {
                return false;
            }
            try {
                return Pattern.matches(pattern, value);
            }
            catch (PatternSyntaxException ex) {
                return false;
            }
        }
        return false;
    }

    public static List<String> asList(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return Collections.emptyList();
        }
        try {
            return IOUtils.readLines((Reader)new StringReader(text));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get lines", e);
        }
    }

    public static String run(File wd, String cmd, String ... args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(cmd);
        list.addAll(Arrays.asList(args));
        try {
            LOGGER.trace("RUN WITH {}", list);
            Process process = new ProcessBuilder(list).directory(wd).start();
            int exit = process.waitFor();
            LOGGER.trace("RUN EXIT {}", (Object)exit);
            if (exit != 0) {
                String error = IOUtils.toString((InputStream)process.getErrorStream());
                LOGGER.trace("RUN ERROR {}", (Object)error);
                throw new ProcessExitException(exit, error);
            }
            String output = IOUtils.toString((InputStream)process.getInputStream());
            LOGGER.trace("RUN OUT   {}", (Object)output);
            return output;
        }
        catch (IOException | InterruptedException ex) {
            throw new ProcessRunException("Error while executing " + cmd + " command: " + ex.getMessage());
        }
    }

    public static String toHexString(byte[] bytes) {
        return Utils.toHexString(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int start, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int b = bytes[start + i] & 0xFF;
            if (b < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(b));
        }
        return buf.toString();
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 is unsupported.");
        }
    }
}

