/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.common;

import java.beans.ConstructorProperties;
import java.util.Arrays;

public class Document {
    private final String type;
    private final byte[] content;
    public static final Document EMPTY = new Document("", new byte[0]);

    public boolean isEmpty() {
        return "".equals(this.type) || this.content == null || this.content.length == 0;
    }

    public static boolean isValid(Document document) {
        return document != null && !document.isEmpty();
    }

    @ConstructorProperties(value={"type", "content"})
    public Document(String type, byte[] content) {
        this.type = type;
        this.content = content;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return Arrays.equals(this.getContent(), other.getContent());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Document;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        result = result * 59 + Arrays.hashCode(this.getContent());
        return result;
    }

    public String toString() {
        return "Document(type=" + this.getType() + ", content=" + Arrays.toString(this.getContent()) + ")";
    }
}

