/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.client;

import java.io.IOException;
import java.net.URL;
import java.util.function.Supplier;
import net.nemerosa.ontrack.client.ClientCannotLoginException;
import net.nemerosa.ontrack.client.ClientForbiddenException;
import net.nemerosa.ontrack.client.ClientIOException;
import net.nemerosa.ontrack.client.ClientMessageException;
import net.nemerosa.ontrack.client.ClientNotFoundException;
import net.nemerosa.ontrack.client.ClientServerException;
import net.nemerosa.ontrack.client.ClientValidationException;
import net.nemerosa.ontrack.client.OTHttpClient;
import net.nemerosa.ontrack.client.OTHttpClientLogger;
import net.nemerosa.ontrack.client.ResponseParser;
import net.nemerosa.ontrack.common.Document;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class OTHttpClientImpl
implements OTHttpClient {
    private final URL url;
    private final HttpHost host;
    private final Supplier<CloseableHttpClient> httpClientSupplier;
    private final HttpClientContext httpContext;
    private final OTHttpClientLogger clientLogger;

    public OTHttpClientImpl(URL url, HttpHost host, Supplier<CloseableHttpClient> httpClientSupplier, HttpClientContext httpContext, OTHttpClientLogger clientLogger) {
        this.url = url;
        this.host = host;
        this.httpClientSupplier = httpClientSupplier;
        this.httpContext = httpContext;
        this.clientLogger = clientLogger;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public String getUrl(String path, Object ... parameters) {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"http")) {
            return String.format(path, parameters);
        }
        String formattedPath = String.format(path, parameters);
        if (!formattedPath.startsWith("/")) {
            formattedPath = "/" + formattedPath;
        }
        return String.format("%s%s", StringUtils.stripEnd((String)this.url.toString(), (String)"/"), formattedPath);
    }

    @Override
    public <T> T get(ResponseParser<T> responseParser, String path, Object ... parameters) {
        return this.request((HttpRequestBase)new HttpGet(this.getUrl(path, parameters)), responseParser);
    }

    @Override
    public <T> T delete(ResponseParser<T> responseParser, String path, Object ... parameters) {
        return this.request((HttpRequestBase)new HttpDelete(this.getUrl(path, parameters)), responseParser);
    }

    @Override
    public <T> T post(ResponseParser<T> responseParser, HttpEntity data, String path, Object ... parameters) {
        HttpPost post = new HttpPost(this.getUrl(path, parameters));
        if (data != null) {
            post.setEntity(data);
        }
        return this.request((HttpRequestBase)post, responseParser);
    }

    @Override
    public <T> T put(ResponseParser<T> responseParser, HttpEntity data, String path, Object ... parameters) {
        HttpPut put = new HttpPut(this.getUrl(path, parameters));
        if (data != null) {
            put.setEntity(data);
        }
        return this.request((HttpRequestBase)put, responseParser);
    }

    @Override
    public <T> T upload(ResponseParser<T> responseParser, String name, Document document, String fileName, String path, Object ... parameters) {
        HttpPost post = new HttpPost(this.getUrl(path, new Object[0]));
        post.setEntity(MultipartEntityBuilder.create().addBinaryBody(name, document.getContent(), ContentType.parse((String)document.getType()), fileName).build());
        return this.request((HttpRequestBase)post, responseParser);
    }

    @Override
    public Document download(String path, Object ... parameters) {
        HttpGet get = new HttpGet(this.getUrl(path, new Object[0]));
        return this.request((HttpRequestBase)get, (HttpRequestBase request, HttpResponse response, HttpEntity entity) -> this.handleErrorCode(request, response, () -> {
            byte[] bytes;
            try {
                bytes = EntityUtils.toByteArray((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new ClientIOException(request, e);
            }
            if (bytes == null || bytes.length == 0) {
                return Document.EMPTY;
            }
            return new Document(entity.getContentType().getValue(), bytes);
        }));
    }

    @Override
    public <T> T request(HttpRequestBase request, ResponseParser<T> responseParser) {
        return (T)this.request(request, (HttpRequestBase request1, HttpResponse response, HttpEntity entity) -> this.baseHandleResponse(request1, response, entity, entity1 -> {
            String content = entity1 != null ? EntityUtils.toString((HttpEntity)entity1, (String)"UTF-8") : null;
            return responseParser.parse(content);
        }));
    }

    @Override
    public CloseableHttpClient getHttpClient() {
        return this.httpClientSupplier.get();
    }

    @Override
    public HttpHost getHttpHost() {
        return this.host;
    }

    @Override
    public HttpClientContext getHttpClientContext() {
        return this.httpContext;
    }

    /*
     * Exception decompiling
     */
    protected <T> T request(HttpRequestBase request, ResponseHandler<T> responseHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected <T> T handleErrorCode(HttpRequestBase request, HttpResponse response, Supplier<T> supplier) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200 || statusCode == 201 || statusCode == 202) {
            return supplier.get();
        }
        if (statusCode == 400) {
            throw new ClientValidationException(OTHttpClientImpl.getMessage(response));
        }
        if (statusCode == 401) {
            throw new ClientCannotLoginException(request);
        }
        if (statusCode == 403) {
            throw new ClientForbiddenException(request);
        }
        if (statusCode == 404) {
            throw new ClientNotFoundException(OTHttpClientImpl.getMessage(response));
        }
        if (statusCode == 204) {
            return null;
        }
        if (statusCode == 500) {
            String content = OTHttpClientImpl.getMessage(response);
            if (StringUtils.isNotBlank((CharSequence)content)) {
                throw new ClientMessageException(content);
            }
            throw new ClientServerException(request, statusCode, response.getStatusLine().getReasonPhrase());
        }
        throw new ClientServerException(request, statusCode, response.getStatusLine().getReasonPhrase());
    }

    protected <T> T baseHandleResponse(HttpRequestBase request, HttpResponse response, HttpEntity entity, EntityParser<T> entityParser) throws ParseException, IOException {
        return (T)this.handleErrorCode(request, response, () -> {
            try {
                return entityParser.parse(entity);
            }
            catch (IOException e) {
                throw new ClientIOException(request, e);
            }
        });
    }

    private static String getMessage(HttpResponse response) throws IOException {
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
    }

    @FunctionalInterface
    protected static interface ResponseHandler<T> {
        public T handleResponse(HttpRequestBase var1, HttpResponse var2, HttpEntity var3) throws ParseException, IOException;
    }

    @FunctionalInterface
    protected static interface EntityParser<T> {
        public T parse(HttpEntity var1) throws IOException;
    }
}

