/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.nemerosa.ontrack.client.ClientURLException;
import net.nemerosa.ontrack.client.OTHttpClient;
import net.nemerosa.ontrack.client.OTHttpClientImpl;
import net.nemerosa.ontrack.client.OTHttpClientLogger;
import net.nemerosa.ontrack.client.OTHttpClientSSLSetupException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTHttpClientBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OTHttpClient.class);
    private final URL url;
    private final boolean disableSsl;
    private final HttpHost host;
    private String username;
    private String password;
    private OTHttpClientLogger clientLogger = new OTHttpClientLogger(){

        @Override
        public void trace(String message) {
            logger.debug(message);
        }
    };

    public static OTHttpClientBuilder create(String url, boolean disableSsl) {
        return new OTHttpClientBuilder(url, disableSsl);
    }

    protected OTHttpClientBuilder(String url, boolean disableSsl) {
        try {
            this.url = new URL(url);
            this.disableSsl = disableSsl;
        }
        catch (MalformedURLException e) {
            throw new ClientURLException(url, e);
        }
        this.host = new HttpHost(this.url.getHost(), this.url.getPort(), this.url.getProtocol());
    }

    public OTHttpClientBuilder withLogger(OTHttpClientLogger httpClientLogger) {
        this.clientLogger = httpClientLogger;
        return this;
    }

    public OTHttpClientBuilder withCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public OTHttpClient build() {
        SSLConnectionSocketFactory sslSocketFactory;
        HttpClientContext httpContext = HttpClientContext.create();
        if (StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.host), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(this.host, (AuthScheme)new BasicScheme());
            httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            httpContext.setAuthCache((AuthCache)authCache);
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        httpContext.setCookieStore((CookieStore)cookieStore);
        if (this.disableSsl) {
            SSLContext ctx;
            logger.warn("Disabling SSL checks!");
            try {
                X509TrustManager x509TrustManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{x509TrustManager}, new SecureRandom());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new OTHttpClientSSLSetupException(e);
            }
            sslSocketFactory = new SSLConnectionSocketFactory(ctx, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        } else {
            logger.debug("Using default secure SSL socket factory.");
            sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        Supplier<CloseableHttpClient> httpClientSupplier = () -> {
            HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(registry));
            return builder.build();
        };
        return new OTHttpClientImpl(this.url, this.host, httpClientSupplier, httpContext, this.clientLogger);
    }
}

