/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.acceptance.boot;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import net.nemerosa.ontrack.acceptance.boot.AcceptanceMissingURLException;
import net.nemerosa.ontrack.acceptance.support.AcceptanceTest;
import net.nemerosa.ontrack.client.ClientException;
import net.nemerosa.ontrack.client.JsonClientImpl;
import net.nemerosa.ontrack.client.OTHttpClient;
import net.nemerosa.ontrack.client.OTHttpClientBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ontrack")
class AcceptanceConfig {
    private final Logger logger = LoggerFactory.getLogger(AcceptanceConfig.class);
    public static final String CONTEXT_ALL = "all";
    private String url;
    private boolean disableSsl = false;
    private String admin = "admin";
    private String context = null;
    private int timeout = 120;
    private int implicitWait = 5;
    private String resultFile = "ontrack-acceptance.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    void check() throws InterruptedException, ExecutionException, TimeoutException {
        if (StringUtils.isBlank((CharSequence)this.url)) {
            throw new AcceptanceMissingURLException();
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            this.logger.info(String.format("Waiting %d s for %s to be available...", this.timeout, this.url));
            AcceptanceTargetCheck check = new AcceptanceTargetCheck();
            Future<String> future = executor.submit(check);
            String version = future.get(this.timeout, TimeUnit.SECONDS);
            this.logger.info(String.format("Getting version %s", version));
        }
        finally {
            executor.shutdownNow();
        }
    }

    public boolean acceptTest(AcceptanceTest acceptanceTest) {
        return StringUtils.isBlank((CharSequence)this.context) || StringUtils.equals((CharSequence)CONTEXT_ALL, (CharSequence)this.context) || acceptanceTest != null && Arrays.asList(acceptanceTest.value()).contains(this.context);
    }

    public void setSystemProperties() {
        System.setProperty("ontrack.url", this.url);
        System.setProperty("ontrack.admin", this.admin);
        System.setProperty("ontrack.disableSsl", String.valueOf(this.disableSsl));
        System.setProperty("ontrack.implicitWait", String.valueOf(this.implicitWait));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isDisableSsl() {
        return this.disableSsl;
    }

    public String getAdmin() {
        return this.admin;
    }

    public String getContext() {
        return this.context;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getImplicitWait() {
        return this.implicitWait;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDisableSsl(boolean disableSsl) {
        this.disableSsl = disableSsl;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setImplicitWait(int implicitWait) {
        this.implicitWait = implicitWait;
    }

    public void setResultFile(String resultFile) {
        this.resultFile = resultFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceptanceConfig)) {
            return false;
        }
        AcceptanceConfig other = (AcceptanceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        if (this.isDisableSsl() != other.isDisableSsl()) {
            return false;
        }
        String this$admin = this.getAdmin();
        String other$admin = other.getAdmin();
        if (this$admin == null ? other$admin != null : !this$admin.equals(other$admin)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getImplicitWait() != other.getImplicitWait()) {
            return false;
        }
        String this$resultFile = this.getResultFile();
        String other$resultFile = other.getResultFile();
        return !(this$resultFile == null ? other$resultFile != null : !this$resultFile.equals(other$resultFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcceptanceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 0 : $logger.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 0 : $url.hashCode());
        result = result * 59 + (this.isDisableSsl() ? 79 : 97);
        String $admin = this.getAdmin();
        result = result * 59 + ($admin == null ? 0 : $admin.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 0 : $context.hashCode());
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getImplicitWait();
        String $resultFile = this.getResultFile();
        result = result * 59 + ($resultFile == null ? 0 : $resultFile.hashCode());
        return result;
    }

    public String toString() {
        return "AcceptanceConfig(logger=" + this.getLogger() + ", url=" + this.getUrl() + ", disableSsl=" + this.isDisableSsl() + ", admin=" + this.getAdmin() + ", context=" + this.getContext() + ", timeout=" + this.getTimeout() + ", implicitWait=" + this.getImplicitWait() + ", resultFile=" + this.getResultFile() + ")";
    }

    private class AcceptanceTargetCheck
    implements Callable<String> {
        private AcceptanceTargetCheck() {
        }

        @Override
        public String call() throws Exception {
            OTHttpClient client = OTHttpClientBuilder.create((String)AcceptanceConfig.this.url, (boolean)AcceptanceConfig.this.disableSsl).build();
            JsonClientImpl jsonClient = new JsonClientImpl(client);
            while (true) {
                try {
                    JsonNode info = jsonClient.get("info", new Object[0]);
                    return info.path("version").path("display").asText();
                }
                catch (ClientException ex) {
                    AcceptanceConfig.this.logger.debug(ex.getMessage());
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
    }
}

