/*
 * Decompiled with CFR 0.152.
 */
package net.nawaman.lambdacalculusj;

import java.util.function.Supplier;
import net.nawaman.lambdacalculusj.Lambda;
import net.nawaman.lambdacalculusj.LambdaCalculus;
import net.nawaman.lambdacalculusj.LambdaWrapper;

public class WholeNumeberLambda
extends LambdaWrapper {
    private final Supplier<Integer> numberValue;

    public WholeNumeberLambda(int numberValue) {
        this((Lambda f) -> LambdaCalculus.lambda(numberValue + "(" + f + ")", a -> {
            Lambda each = a;
            for (int i = 0; i < numberValue; ++i) {
                each = LambdaCalculus.lazy(f, each);
            }
            return each;
        }), () -> numberValue);
        if (numberValue < 0) {
            throw new IllegalArgumentException("Number for the WholeNumericLambda cannot be negative: " + numberValue);
        }
    }

    public WholeNumeberLambda(Lambda lambda, Supplier<Integer> numberValue) {
        super(null, lambda);
        this.numberValue = numberValue;
    }

    @Override
    public Integer intValue() {
        try {
            return this.numberValue.get();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        Integer intValue = this.intValue();
        return intValue != null ? "" + intValue : "NAN";
    }
}

