/*
 * Decompiled with CFR 0.152.
 */
package net.nawaman.lambdacalculusj;

import net.nawaman.lambdacalculusj.ArithmeticsHelper;
import net.nawaman.lambdacalculusj.Lambda;
import net.nawaman.lambdacalculusj.LambdaCalculus;
import net.nawaman.lambdacalculusj.WholeNumeberLambda;

public interface WholeNumbers {
    public static final Lambda successor = LambdaCalculus.lambda("successor", n -> WholeNumbers.wholeNumber(ArithmeticsHelper.mapInt(n, i -> i + 1)));
    public static final Lambda predecessor = LambdaCalculus.lambda("predecessor", n -> WholeNumbers.wholeNumber(ArithmeticsHelper.mapInt(n, i -> Math.max(0, i - 1))));
    public static final Lambda add = LambdaCalculus.lambda("add", n -> m -> WholeNumbers.wholeNumber(ArithmeticsHelper.mapInts(n, m, (i, j) -> i + j)));
    public static final Lambda subtract = LambdaCalculus.lambda("subtract", n -> m -> WholeNumbers.wholeNumber(ArithmeticsHelper.mapInts(n, m, (i, j) -> Math.max(0, i - j))));
    public static final Lambda multiply = LambdaCalculus.lambda("multiply", n -> m -> WholeNumbers.wholeNumber(ArithmeticsHelper.mapInts(n, m, (i, j) -> i * j)));
    public static final Lambda divide = LambdaCalculus.lambda("divide", n -> m -> WholeNumbers.wholeNumber(ArithmeticsHelper.mapInts(n, m, (i, j) -> i / j)));
    public static final Lambda moduro = LambdaCalculus.lambda("moduro", n -> m -> WholeNumbers.wholeNumber(ArithmeticsHelper.mapInts(n, m, (i, j) -> i % j)));
    public static final Lambda power = LambdaCalculus.lambda("power", n -> m -> WholeNumbers.wholeNumber(ArithmeticsHelper.mapInts(n, m, (i, j) -> (int)Math.pow(i, j))));
    public static final Lambda isNumber = LambdaCalculus.lambda("isNumber", n -> LambdaCalculus.lambda(ArithmeticsHelper.checkInt(n, i -> true)));
    public static final Lambda isZero = LambdaCalculus.lambda("isZero", n -> LambdaCalculus.lambda(ArithmeticsHelper.checkInt(n, i -> i == 0)));
    public static final Lambda equal = LambdaCalculus.lambda("equal", n -> m -> LambdaCalculus.lambda(ArithmeticsHelper.checkInts(n, m, (i, j) -> i == j)));
    public static final Lambda lessOrEqual = LambdaCalculus.lambda("lessOrEqual", n -> m -> LambdaCalculus.lambda(ArithmeticsHelper.checkInts(n, m, (i, j) -> i <= j)));
    public static final Lambda greaterOrEqual = LambdaCalculus.lambda("greaterOrEqual", n -> m -> LambdaCalculus.lambda(ArithmeticsHelper.checkInts(n, m, (i, j) -> i >= j)));
    public static final Lambda lessThan = LambdaCalculus.lambda("lessThan", n -> m -> LambdaCalculus.lambda(ArithmeticsHelper.checkInts(n, m, (i, j) -> i < j)));
    public static final Lambda greaterThan = LambdaCalculus.lambda("greaterThan", n -> m -> LambdaCalculus.lambda(ArithmeticsHelper.checkInts(n, m, (i, j) -> i > j)));

    public static Lambda wholeNumber(int wholeNumberValue) {
        return new WholeNumeberLambda(wholeNumberValue);
    }
}

