/*
 * Decompiled with CFR 0.152.
 */
package net.nawaman.lambdacalculusj;

import java.util.function.Supplier;
import net.nawaman.lambdacalculusj.Lambda;
import net.nawaman.lambdacalculusj.LazyEvaluatingLambdaException;

public class LazyLambda
implements Lambda {
    private final Supplier<String> toString;
    private final Lambda lambda;
    private final Lambda input;

    public LazyLambda(Lambda lambda, Lambda input) {
        this(() -> lambda.toString(), lambda, input);
    }

    public LazyLambda(String toString, Lambda lambda, Lambda input) {
        this(() -> toString, lambda, input);
    }

    public LazyLambda(Supplier<String> toString, Lambda lambda, Lambda input) {
        this.toString = toString;
        this.lambda = lambda;
        this.input = input;
    }

    @Override
    public Lambda apply(Lambda subInput) {
        return this.evaluate().apply(subInput);
    }

    @Override
    public Lambda evaluate() {
        try {
            return this.lambda.evaluate().apply(this.input).evaluate();
        }
        catch (StackOverflowError e) {
            throw new LazyEvaluatingLambdaException(this.lambda, this.input, e);
        }
    }

    @Override
    public Integer intValue() {
        return this.evaluate().intValue();
    }

    public String toString() {
        return String.format("%s(%s)", this.toString.get(), this.input.toString());
    }
}

