/*
 * Decompiled with CFR 0.152.
 */
package net.nawaman.lambdacalculusj;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.nawaman.lambdacalculusj.Lambda;
import net.nawaman.lambdacalculusj.LambdaWrapper;
import net.nawaman.lambdacalculusj.LazyEvaluatingLambdaException;
import net.nawaman.lambdacalculusj.LazyLambda;
import net.nawaman.lambdacalculusj.WholeNumeberLambda;

public class LambdaCalculus {
    private static final Lambda TRUE = LambdaCalculus.lambda("true", (Lambda x) -> y -> x);
    private static final Lambda FALSE = LambdaCalculus.lambda("false", (Lambda x) -> y -> y);

    private LambdaCalculus() {
    }

    public static Lambda \u03bb(Lambda lambda) {
        return LambdaCalculus.lambda(lambda);
    }

    public static Lambda \u03bb(String name, Lambda lambda) {
        return LambdaCalculus.lambda(name, lambda);
    }

    public static Lambda \u03bb(Lambda lambda, Supplier<Integer> intValue) {
        return LambdaCalculus.lambda(lambda, intValue);
    }

    public static Lambda lambda(Lambda lambda) {
        return new LambdaWrapper(null, lambda);
    }

    public static Lambda lambda(String name, Lambda lambda) {
        return new LambdaWrapper(name, lambda);
    }

    public static Lambda lambda(Lambda lambda, Supplier<Integer> intValue) {
        return new WholeNumeberLambda(lambda, intValue);
    }

    public static Lambda wholeNumber(int wholeNumberValue) {
        return new WholeNumeberLambda(wholeNumberValue);
    }

    public static Lambda lambda(boolean booleanValue) {
        return booleanValue ? TRUE : FALSE;
    }

    public static Lambda $(Lambda lambda, Lambda ... inputs) {
        return LambdaCalculus.lambda(lambda, inputs).evaluate();
    }

    public static Lambda lazy(Lambda lambda, Lambda ... inputs) {
        if (!(lambda instanceof LambdaWrapper) && !(lambda instanceof LazyLambda)) {
            lambda = LambdaCalculus.lambda(lambda);
        }
        return LambdaCalculus.lambda(lambda, inputs);
    }

    public static Lambda lambda(Lambda lambda, Lambda ... inputs) {
        if (inputs.length == 0) {
            if (lambda instanceof LambdaWrapper || lambda instanceof LazyLambda) {
                return lambda;
            }
            return new LambdaWrapper(null, lambda);
        }
        if (inputs.length == 1) {
            Lambda input = inputs[0];
            return new LazyLambda(lambda, input);
        }
        Lambda firstInput = inputs[0];
        Lambda[] restInputs = new Lambda[inputs.length - 1];
        System.arraycopy(inputs, 1, restInputs, 0, restInputs.length);
        LazyLambda newLambda = new LazyLambda(lambda, firstInput);
        return LambdaCalculus.lazy(newLambda, restInputs);
    }

    public static String format(String template, Lambda ... values) {
        return String.format(template, Stream.of(values).map(LambdaCalculus::displayValue).toArray());
    }

    public static String displayValue(Lambda lambda) {
        Object valueString = null;
        try {
            valueString = lambda.evaluate().toString();
            if (((String)valueString).matches("[a-zA-Z0-9$_.]+\\$\\$Lambda\\$[0-9]+/0x[0-9a-fA-F]+@[0-9a-fA-F]+")) {
                valueString = lambda.toString();
            }
        }
        catch (LazyEvaluatingLambdaException error) {
            valueString = lambda.toString() + "'";
        }
        return valueString;
    }

    public static Integer intValue(Lambda lambda) {
        Integer intValue = lambda.intValue();
        if (intValue != null) {
            return intValue;
        }
        AtomicReference<Integer> counter = new AtomicReference<Integer>(0);
        Lambda input = LambdaCalculus.lambda("input", (Lambda a) -> a);
        Lambda func = LambdaCalculus.lambda("func", (Lambda a) -> {
            if (a != input) {
                counter.set(null);
                return a;
            }
            Integer value = (Integer)counter.get();
            if (value instanceof Integer) {
                counter.set(value + 1);
            }
            return a;
        });
        Lambda result = LambdaCalculus.$(lambda, func, input);
        return input == result ? counter.get() : null;
    }

    public static Lambda show(Lambda lambda, Lambda ... inputs) {
        return LambdaCalculus.show(null, lambda, inputs);
    }

    public static Lambda show(String description, Lambda lambda, Lambda ... inputs) {
        Lambda value = LambdaCalculus.lazy(lambda, inputs);
        String valueString = LambdaCalculus.displayValue(value);
        if (description == null) {
            LambdaCalculus.println(valueString);
        } else {
            LambdaCalculus.println(description + ": " + valueString);
        }
        return value;
    }

    public static void section(String section) {
        LambdaCalculus.println("== " + section + " ==================");
    }

    public static void println() {
        LambdaCalculus.println("");
    }

    public static void println(Object object) {
        System.out.println(object);
    }
}

