/*
 * Decompiled with CFR 0.152.
 */
package net.nawaman.istream;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.nawaman.istream.ExtensibleStream;

public interface IStream<DATA>
extends ExtensibleStream<DATA> {
    public static <D> IStream<D> empty() {
        return IStream.forArray(new Object[0]);
    }

    @SafeVarargs
    public static <D> IStream<D> of(D ... values) {
        return () -> Stream.of(values);
    }

    public static <D> IStream<D> from(Collection<D> values) {
        return () -> values.stream();
    }

    @SafeVarargs
    public static <D> IStream<D> forArray(D ... values) {
        return () -> Stream.of(values);
    }

    public static <D> IStream<D> forCollection(Collection<D> values) {
        return () -> values.stream();
    }

    @Override
    default public List<DATA> toList() {
        return this.collect(Collectors.toList());
    }

    default public IStream<DATA> concatWith(Stream<DATA> tail) {
        if (tail == null) {
            return this;
        }
        return () -> Stream.concat(this, tail);
    }

    default public IStream<DATA> concatWith(DATA ... tails) {
        if (tails == null) {
            return this;
        }
        return () -> Stream.concat(this, Stream.of(tails));
    }

    default public IStream<DATA> concatWith(Collection<DATA> tail) {
        if (tail == null) {
            return this;
        }
        return () -> Stream.concat(this, tail.stream());
    }
}

