/*
 * Decompiled with CFR 0.152.
 */
package net.nan21.dnet.module.ad.usr.ds.converter;

import javax.persistence.NoResultException;
import net.nan21.dnet.core.api.converter.IDsConverter;
import net.nan21.dnet.core.presenter.converter.AbstractDsConverter;
import net.nan21.dnet.module.ad.usr.business.service.IBookmarkService;
import net.nan21.dnet.module.ad.usr.domain.entity.Bookmark;
import net.nan21.dnet.module.ad.usr.ds.model.BookmarkDs;

public class BookmarkDsConv
extends AbstractDsConverter<BookmarkDs, Bookmark>
implements IDsConverter<BookmarkDs, Bookmark> {
    protected void modelToEntityReferences(BookmarkDs ds, Bookmark e, boolean isInsert) throws Exception {
        if (ds.getParentId() != null) {
            if (e.getParent() == null || !e.getParent().getId().equals(ds.getParentId())) {
                e.setParent((Bookmark)this.em.find(Bookmark.class, (Object)ds.getParentId()));
            }
        } else {
            this.lookup_parent_Bookmark(ds, e);
        }
    }

    protected void lookup_parent_Bookmark(BookmarkDs ds, Bookmark e) throws Exception {
        if (ds.getOwner() != null && !ds.getOwner().equals("") && ds.getParent() != null && !ds.getParent().equals("")) {
            Bookmark x = null;
            try {
                x = ((IBookmarkService)this.findEntityService(Bookmark.class)).findByName(ds.getOwner(), ds.getParent());
            }
            catch (NoResultException exception) {
                throw new Exception("Invalid value provided to find `Bookmark` reference: `owner` = " + ds.getOwner() + ", `parent` = " + ds.getParent() + "");
            }
            e.setParent(x);
        } else {
            e.setParent(null);
        }
    }
}

