/*
 * Decompiled with CFR 0.152.
 */
package net.nan21.dnet.module.ad._presenterdelegates.impex;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.nan21.dnet.core.api.action.IDsExport;
import net.nan21.dnet.core.api.action.IQueryBuilder;
import net.nan21.dnet.core.api.action.SortToken;
import net.nan21.dnet.core.api.service.IDsService;
import net.nan21.dnet.core.api.session.Params;
import net.nan21.dnet.core.api.session.Session;
import net.nan21.dnet.core.presenter.action.DsCsvExport;
import net.nan21.dnet.core.presenter.service.AbstractDsDelegate;
import net.nan21.dnet.module.ad.impex.business.service.ICsvExportFieldService;
import net.nan21.dnet.module.ad.impex.business.service.ICsvExportService;
import net.nan21.dnet.module.ad.impex.business.service.IExportMapItemService;
import net.nan21.dnet.module.ad.impex.business.service.IExportMapService;
import net.nan21.dnet.module.ad.impex.domain.entity.CsvExport;
import net.nan21.dnet.module.ad.impex.domain.entity.CsvExportField;
import net.nan21.dnet.module.ad.impex.domain.entity.CsvExportSort;
import net.nan21.dnet.module.ad.impex.domain.entity.ExportJobItem;
import net.nan21.dnet.module.ad.impex.domain.entity.ExportMap;
import net.nan21.dnet.module.ad.impex.domain.entity.ExportMapItem;
import net.nan21.dnet.module.ad.impex.ds.model.ExportJobDs;
import net.nan21.dnet.module.ad.impex.ds.model.ExportJobItemDs;
import net.nan21.dnet.module.ad.impex.ds.model.ExportMapDs;
import net.nan21.dnet.module.ad.impex.ds.model.ExportMapItemDs;

public class ExportPD
extends AbstractDsDelegate {
    public void exportFromJob(ExportJobDs ds) throws Exception {
        IExportMapService srv = (IExportMapService)this.findEntityService(ExportMap.class);
        List list = srv.getEntityManager().createQuery("  select i.map.id from " + ExportJobItem.class.getSimpleName() + " i where i.active=true and i.job.id = :pJobId   ", Long.class).setParameter("pJobId", (Object)ds.getId()).getResultList();
        for (Long id : list) {
            this.exportByMapId(id);
        }
    }

    public void exportFromJobItem(ExportJobItemDs ds) throws Exception {
        this.exportByMapId(ds.getMapId());
    }

    public void exportFromMap(ExportMapDs ds) throws Exception {
        this.exportByMapId(ds.getId());
    }

    public void exportFromMapItem(ExportMapItemDs ds) throws Exception {
        ExportMapItem mapItem = (ExportMapItem)((IExportMapItemService)this.findEntityService(ExportMapItem.class)).findById((Object)ds.getId());
        this.doWork(mapItem);
    }

    private void exportByMapId(Long mapId) throws Exception {
        ICsvExportService srv = (ICsvExportService)this.findEntityService(CsvExport.class);
        String mapItemEql = "select e from " + ExportMapItem.class.getSimpleName() + " e where e.active=true and e.exportMap.id = :pMapId" + " and e.csvExport.active = true ";
        List list = srv.getEntityManager().createQuery(mapItemEql, ExportMapItem.class).setParameter("pMapId", (Object)mapId).getResultList();
        for (ExportMapItem mapItem : list) {
            this.doWork(mapItem);
        }
    }

    private void doWork(ExportMapItem mapItem) throws Exception {
        String _itemPath;
        ExportMap map = mapItem.getExportMap();
        CsvExport csvExport = mapItem.getCsvExport();
        File file = null;
        String _path = _itemPath = mapItem.getPath();
        String _mapPath = map.getPath();
        String _clientExportPath = ((Params)Session.params.get()).getDefaultExportPath();
        String _fileName = mapItem.getFileName();
        if (_fileName == null || _fileName.equals("")) {
            _fileName = csvExport.getDataSource() + ".csv";
        }
        if (!new File(_path).isAbsolute()) {
            if (_mapPath != null && !_mapPath.equals("")) {
                _path = _mapPath + File.separator + _path;
            }
            if (!new File(_path).isAbsolute()) {
                if (_clientExportPath != null && !_clientExportPath.equals("")) {
                    _path = _clientExportPath + File.separator + _path;
                } else {
                    throw new Exception("Cannot export file. All paths are relative but client level export path is not set.");
                }
            }
        }
        _fileName = _path + File.separator + _fileName;
        try {
            File dir = new File(_path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file = new File(_fileName);
        }
        catch (Exception e) {
            throw new Exception("Cannot create file `" + _fileName + "`. Reason: " + e.getMessage());
        }
        try {
            ICsvExportFieldService csvExportFieldService = (ICsvExportFieldService)this.findEntityService(CsvExportField.class);
            IDsService dsService = this.findDsService(csvExport.getDataSource() + "Ds");
            IQueryBuilder builder = dsService.createQueryBuilder();
            DsCsvExport writer = new DsCsvExport(dsService.getModelClass());
            ArrayList<String> fieldNames = new ArrayList<String>();
            List fields = csvExportFieldService.getEntityManager().createQuery("select e from " + CsvExportField.class.getSimpleName() + " e " + "where e.active = true " + "  and e.csvExport.id = :csvExportId " + " order by e.sequenceNo  ", CsvExportField.class).setParameter("csvExportId", (Object)csvExport.getId()).getResultList();
            for (CsvExportField f : fields) {
                fieldNames.add(f.getDsField());
            }
            List sorts = csvExportFieldService.getEntityManager().createQuery("select e from " + CsvExportSort.class.getSimpleName() + " e " + "where e.csvExport.id = :csvExportId " + " order by e.sequenceNo  ", CsvExportSort.class).setParameter("csvExportId", (Object)csvExport.getId()).getResultList();
            ArrayList<SortToken> sortTokens = new ArrayList<SortToken>();
            for (CsvExportSort s : sorts) {
                SortToken t = new SortToken();
                t.setProperty(s.getDsField());
                if (s.getDescend().booleanValue()) {
                    t.setDirection("desc");
                } else {
                    t.setDirection("asc");
                }
                sortTokens.add(t);
            }
            builder.addSortInfo(sortTokens);
            writer.setFieldNames(fieldNames);
            writer.setOutFile(file);
            dsService.doExport(null, null, builder, (IDsExport)writer);
        }
        catch (Exception e) {
            throw new Exception("Cannot export csvExport `" + mapItem.getCsvExport().getName() + "`. Reason: " + e.getMessage());
        }
    }
}

