/* 
 * DNet eBusiness Suite
 * Copyright: Nan21 Electronics SRL. All rights reserved.
 * Use is subject to license terms.
 */
package net.nan21.dnet.module.ad.workflow.ds.converter;

import net.nan21.dnet.core.api.converter.IDsConverter;
import net.nan21.dnet.core.presenter.converter.AbstractDsConverter;
import net.nan21.dnet.module.ad.workflow.domain.entity.WfDefNode;
import net.nan21.dnet.module.ad.workflow.domain.entity.WfDefProcess;
import net.nan21.dnet.module.ad.workflow.ds.model.WfDefNodeDs;

public class WfDefNodeDsConv extends AbstractDsConverter<WfDefNodeDs, WfDefNode> 
		implements IDsConverter<WfDefNodeDs, WfDefNode> {
    
    @Override
    protected void modelToEntityReferences(WfDefNodeDs ds, WfDefNode e, boolean isInsert) throws Exception {
    	if( ds.getProcessId() != null  ) {
    		if (e.getProcess() == null || !e.getProcess().getId().equals(ds.getProcessId()) ) {
    			e.setProcess( (WfDefProcess) this.em.find(WfDefProcess.class, ds.getProcessId() ) );
    		}
    	}
    }
}
