/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util.regex;

import net.named_data.jndn.util.regex.NdnRegexBackrefManager;
import net.named_data.jndn.util.regex.NdnRegexBackrefMatcher;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;
import net.named_data.jndn.util.regex.NdnRegexRepeatMatcher;

public class NdnRegexPatternListMatcher
extends NdnRegexMatcherBase {
    public NdnRegexPatternListMatcher(String expr, NdnRegexBackrefManager backrefManager) throws NdnRegexMatcherBase.Error {
        super(expr, NdnRegexMatcherBase.NdnRegexExprType.PATTERN_LIST, backrefManager);
        this.compile();
    }

    @Override
    protected void compile() throws NdnRegexMatcherBase.Error {
        int len = this.expr_.length();
        int[] index = new int[]{0};
        int subHead = index[0];
        while (index[0] < len) {
            subHead = index[0];
            if (this.extractPattern(subHead, index)) continue;
            throw new NdnRegexMatcherBase.Error("Compile error");
        }
    }

    private boolean extractPattern(int index, int[] next) throws NdnRegexMatcherBase.Error {
        int start = index;
        int end = index;
        int indicator = index;
        if (this.expr_.charAt(index) == '(') {
            ++index;
            indicator = index = this.extractSubPattern('(', ')', index);
            if (indicator == (end = this.extractRepetition(index))) {
                NdnRegexBackrefMatcher matcher = new NdnRegexBackrefMatcher(this.expr_.substring(start, end), this.backrefManager_);
                this.backrefManager_.pushRef(matcher);
                matcher.lateCompile();
                this.matchers_.add(matcher);
            } else {
                this.matchers_.add(new NdnRegexRepeatMatcher(this.expr_.substring(start, end), this.backrefManager_, indicator - start));
            }
        } else if (this.expr_.charAt(index) == '<') {
            ++index;
            indicator = index = this.extractSubPattern('<', '>', index);
            end = this.extractRepetition(index);
            this.matchers_.add(new NdnRegexRepeatMatcher(this.expr_.substring(start, end), this.backrefManager_, indicator - start));
        } else if (this.expr_.charAt(index) == '[') {
            ++index;
            indicator = index = this.extractSubPattern('[', ']', index);
            end = this.extractRepetition(index);
            this.matchers_.add(new NdnRegexRepeatMatcher(this.expr_.substring(start, end), this.backrefManager_, indicator - start));
        } else {
            throw new NdnRegexMatcherBase.Error("Unexpected syntax");
        }
        next[0] = end;
        return true;
    }

    private int extractSubPattern(char left, char right, int index) throws NdnRegexMatcherBase.Error {
        int lcount = 1;
        int rcount = 0;
        while (lcount > rcount) {
            if (index >= this.expr_.length()) {
                throw new NdnRegexMatcherBase.Error("Parenthesis mismatch");
            }
            if (left == this.expr_.charAt(index)) {
                ++lcount;
            }
            if (right == this.expr_.charAt(index)) {
                ++rcount;
            }
            ++index;
        }
        return index;
    }

    private int extractRepetition(int index) throws NdnRegexMatcherBase.Error {
        int exprSize = this.expr_.length();
        if (index == exprSize) {
            return index;
        }
        if ('+' == this.expr_.charAt(index) || '?' == this.expr_.charAt(index) || '*' == this.expr_.charAt(index)) {
            return ++index;
        }
        if ('{' == this.expr_.charAt(index)) {
            while ('}' != this.expr_.charAt(index) && ++index != exprSize) {
            }
            if (index == exprSize) {
                throw new NdnRegexMatcherBase.Error("Missing right brace bracket");
            }
            return ++index;
        }
        return index;
    }
}

