/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util.regex;

import java.util.ArrayList;
import net.named_data.jndn.Name;
import net.named_data.jndn.util.regex.NdnRegexBackrefManager;

public abstract class NdnRegexMatcherBase {
    protected final String expr_;
    protected final NdnRegexExprType type_;
    protected final NdnRegexBackrefManager backrefManager_;
    protected final ArrayList<NdnRegexMatcherBase> matchers_ = new ArrayList();
    protected final ArrayList<Name.Component> matchResult_ = new ArrayList();

    public NdnRegexMatcherBase(String expr, NdnRegexExprType type, NdnRegexBackrefManager backrefManager) {
        this.expr_ = expr;
        this.type_ = type;
        this.backrefManager_ = backrefManager;
    }

    public NdnRegexMatcherBase(String expr, NdnRegexExprType type) {
        this.expr_ = expr;
        this.type_ = type;
        this.backrefManager_ = new NdnRegexBackrefManager();
    }

    public boolean match(Name name, int offset, int len) throws Error {
        boolean result = false;
        this.matchResult_.clear();
        if (this.recursiveMatch(0, name, offset, len)) {
            for (int i = offset; i < offset + len; ++i) {
                this.matchResult_.add(name.get(i));
            }
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public final ArrayList<Name.Component> getMatchResult() {
        return this.matchResult_;
    }

    public final String getExpr() {
        return this.expr_;
    }

    protected abstract void compile() throws Error;

    private boolean recursiveMatch(int matcherNo, Name name, int offset, int len) throws Error {
        if (matcherNo >= this.matchers_.size()) {
            return len == 0;
        }
        NdnRegexMatcherBase matcher = this.matchers_.get(matcherNo);
        for (int tried = len; tried >= 0; --tried) {
            if (!matcher.match(name, offset, tried) || !this.recursiveMatch(matcherNo + 1, name, offset + tried, len - tried)) continue;
            return true;
        }
        return false;
    }

    public static enum NdnRegexExprType {
        TOP,
        PATTERN_LIST,
        REPEAT_PATTERN,
        BACKREF,
        COMPONENT_SET,
        COMPONENT,
        PSEUDO;

    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

