/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.named_data.jndn.util.Common;

public class ConfigFile {
    private String path_;
    private final HashMap<String, String> config_ = new HashMap();

    public ConfigFile() throws IOException {
        this.path_ = ConfigFile.findConfigFile();
        if (!this.path_.equals("")) {
            this.parse();
        }
    }

    public final String get(String key, String defaultValue) {
        if (this.config_.containsKey(key)) {
            return this.config_.get(key);
        }
        return defaultValue;
    }

    public final String getPath() {
        return this.path_;
    }

    public final Map<String, String> getParsedConfiguration() {
        return this.config_;
    }

    private static String findConfigFile() {
        File filePath = new File(new File(Common.getHomeDirectory(), ".ndn"), "client.conf");
        if (filePath.exists()) {
            return filePath.getAbsolutePath();
        }
        filePath = new File("/etc/ndn/client.conf");
        if (filePath.exists()) {
            return filePath.getAbsolutePath();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        BufferedReader input;
        if (this.path_.equals("")) {
            throw new Error("ConfigFile.parse: Failed to locate the configuration file for parsing");
        }
        try {
            input = new BufferedReader(new FileReader(this.path_));
        }
        catch (FileNotFoundException ex) {
            throw new Error(ex.getMessage());
        }
        try {
            String line;
            while ((line = input.readLine()) != null) {
                int iSeparator;
                if ((line = line.trim()).equals("") || line.charAt(0) == ';' || (iSeparator = line.indexOf(61)) < 0) continue;
                String key = line.substring(0, iSeparator).trim();
                String value = line.substring(iSeparator + 1).trim();
                this.config_.put(key, value);
            }
        }
        finally {
            input.close();
        }
    }
}

