/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class Blob
implements Comparable {
    private final ByteBuffer buffer_;
    private boolean haveHashCode_ = false;
    private int hashCode_;

    public Blob() {
        this.buffer_ = null;
    }

    public Blob(Blob blob) {
        this.buffer_ = blob != null ? blob.buffer_ : null;
    }

    public Blob(ByteBuffer buffer, boolean copy) {
        if (buffer != null) {
            if (copy) {
                this.buffer_ = ByteBuffer.allocate(buffer.remaining());
                int savePosition = buffer.position();
                this.buffer_.put(buffer);
                buffer.position(savePosition);
                this.buffer_.flip();
            } else {
                this.buffer_ = buffer.slice();
            }
        } else {
            this.buffer_ = null;
        }
    }

    public Blob(byte[] value, boolean copy) {
        if (copy) {
            this.buffer_ = ByteBuffer.allocate(value.length);
            this.buffer_.put(value);
            this.buffer_.flip();
        } else {
            this.buffer_ = ByteBuffer.wrap(value);
        }
    }

    public Blob(byte[] value) {
        this.buffer_ = ByteBuffer.allocate(value.length);
        this.buffer_.put(value);
        this.buffer_.flip();
    }

    public Blob(int[] value) {
        this.buffer_ = ByteBuffer.allocate(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.buffer_.put((byte)value[i]);
        }
        this.buffer_.flip();
    }

    public Blob(String value) {
        byte[] utf8;
        try {
            utf8 = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error("UTF-8 encoder not supported: " + ex.getMessage());
        }
        this.buffer_ = ByteBuffer.allocate(utf8.length);
        this.buffer_.put(utf8);
        this.buffer_.flip();
    }

    public final ByteBuffer buf() {
        if (this.buffer_ != null) {
            return this.buffer_.asReadOnlyBuffer();
        }
        return null;
    }

    public final byte[] getImmutableArray() {
        if (this.buffer_ != null) {
            byte[] array;
            if (!this.buffer_.isReadOnly() && (array = this.buffer_.array()).length == this.buffer_.remaining()) {
                return array;
            }
            ByteBuffer tempBuffer = ByteBuffer.allocate(this.buffer_.remaining());
            int savePosition = this.buffer_.position();
            tempBuffer.put(this.buffer_);
            this.buffer_.position(savePosition);
            tempBuffer.flip();
            return tempBuffer.array();
        }
        return null;
    }

    public final int size() {
        if (this.buffer_ != null) {
            return this.buffer_.remaining();
        }
        return 0;
    }

    public final boolean isNull() {
        return this.buffer_ == null;
    }

    public final String toHex() {
        if (this.buffer_ == null) {
            return "";
        }
        return Blob.toHex(this.buffer_);
    }

    public static void toHex(ByteBuffer buffer, StringBuffer output) {
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            String hex = Integer.toHexString(buffer.get(i) & 0xFF);
            if (hex.length() <= 1) {
                output.append("0");
            }
            output.append(hex);
        }
    }

    public static String toHex(ByteBuffer buffer) {
        StringBuffer output = new StringBuffer(buffer.remaining() * 2);
        Blob.toHex(buffer, output);
        return output.toString();
    }

    public final boolean equals(Blob other) {
        if (this.buffer_ == null) {
            return other.buffer_ == null;
        }
        if (other.isNull()) {
            return false;
        }
        return this.buffer_.equals(other.buffer_);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Blob)) {
            return false;
        }
        return this.equals((Blob)other);
    }

    public final int compare(Blob other) {
        if (this.buffer_ == null && other.buffer_ == null) {
            return 0;
        }
        if (this.buffer_ == null && other.buffer_ != null) {
            return -1;
        }
        if (this.buffer_ != null && other.buffer_ == null) {
            return 1;
        }
        int r = Math.min(this.buffer_.remaining(), other.buffer_.remaining());
        for (int i = 0; i < r; ++i) {
            int xOther;
            int xThis = this.buffer_.get(this.buffer_.position() + i) & 0xFF;
            if (xThis < (xOther = other.buffer_.get(other.buffer_.position() + i) & 0xFF)) {
                return -1;
            }
            if (xThis <= xOther) continue;
            return 1;
        }
        if (this.buffer_.remaining() < other.buffer_.remaining()) {
            return -1;
        }
        if (this.buffer_.remaining() > other.buffer_.remaining()) {
            return 1;
        }
        return 0;
    }

    public final int compareTo(Object o) {
        return this.compare((Blob)o);
    }

    public final int CompareTo(Object o) {
        return this.compare((Blob)o);
    }

    public int hashCode() {
        if (!this.haveHashCode_) {
            this.hashCode_ = this.buffer_ == null ? 0 : this.buffer_.hashCode();
            this.haveHashCode_ = true;
        }
        return this.hashCode_;
    }

    public String toString() {
        if (this.buffer_ == null) {
            return "";
        }
        try {
            return new String(this.getImmutableArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error("UTF-8 decoder not supported: " + ex.getMessage());
        }
    }
}

