/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2.validator_config;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.security.v2.validator_config.ConfigChecker;
import net.named_data.jndn.security.v2.validator_config.ConfigFilter;
import net.named_data.jndn.util.BoostInfoTree;

public class ConfigRule {
    private final String id_;
    private final boolean isForInterest_;
    private final ArrayList<ConfigFilter> filters_ = new ArrayList();
    private final ArrayList<ConfigChecker> checkers_ = new ArrayList();
    private static final Logger logger_ = Logger.getLogger(ConfigRule.class.getName());

    public ConfigRule(String id, boolean isForInterest) {
        this.id_ = id;
        this.isForInterest_ = isForInterest;
    }

    public final String getId() {
        return this.id_;
    }

    public final boolean getIsForInterest() {
        return this.isForInterest_;
    }

    public final void addFilter(ConfigFilter filter) {
        this.filters_.add(filter);
    }

    public final void addChecker(ConfigChecker checker) {
        this.checkers_.add(checker);
    }

    public final boolean match(boolean isForInterest, Name packetName) throws ValidatorConfigError {
        logger_.log(Level.FINE, "Trying to match {0}", packetName.toUri());
        if (isForInterest != this.isForInterest_) {
            throw new ValidatorConfigError("Invalid packet type supplied ( " + (isForInterest ? "interest" : "data") + " != " + (this.isForInterest_ ? "interest" : "data") + ")");
        }
        if (this.filters_.size() == 0) {
            return true;
        }
        boolean result = false;
        for (int i = 0; i < this.filters_.size(); ++i) {
            boolean bl = result = result || this.filters_.get(i).match(isForInterest, packetName);
            if (result) break;
        }
        return result;
    }

    public final boolean check(boolean isForInterest, Name packetName, Name keyLocatorName, ValidationState state) throws ValidatorConfigError {
        logger_.log(Level.FINE, "Trying to check {0} with keyLocator {1}", new Object[]{packetName.toUri(), keyLocatorName.toUri()});
        if (isForInterest != this.isForInterest_) {
            throw new ValidatorConfigError("Invalid packet type supplied ( " + (isForInterest ? "interest" : "data") + " != " + (this.isForInterest_ ? "interest" : "data") + ")");
        }
        boolean hasPendingResult = false;
        for (int i = 0; i < this.checkers_.size(); ++i) {
            boolean result = this.checkers_.get(i).check(isForInterest, packetName, keyLocatorName, state);
            if (!result) {
                return result;
            }
            hasPendingResult = true;
        }
        return hasPendingResult;
    }

    public static ConfigRule create(BoostInfoTree configSection) throws ValidatorConfigError {
        boolean isForInterest;
        String ruleId = configSection.getFirstValue("id");
        if (ruleId == null) {
            throw new ValidatorConfigError("Expecting <rule.id>");
        }
        String usage = configSection.getFirstValue("for");
        if (usage == null) {
            throw new ValidatorConfigError("Expecting <rule.for> in rule: " + ruleId);
        }
        if (usage.equalsIgnoreCase("data")) {
            isForInterest = false;
        } else if (usage.equalsIgnoreCase("interest")) {
            isForInterest = true;
        } else {
            throw new ValidatorConfigError("Unrecognized <rule.for>: " + usage + " in rule: " + ruleId);
        }
        ConfigRule rule = new ConfigRule(ruleId, isForInterest);
        ArrayList<BoostInfoTree> filterList = configSection.get("filter");
        for (int i = 0; i < filterList.size(); ++i) {
            rule.addFilter(ConfigFilter.create(filterList.get(i)));
        }
        ArrayList<BoostInfoTree> checkerList = configSection.get("checker");
        for (int i = 0; i < checkerList.size(); ++i) {
            rule.addChecker(ConfigChecker.create(checkerList.get(i)));
        }
        if (checkerList.size() == 0) {
            throw new ValidatorConfigError("No <rule.checker> is specified in rule: " + ruleId);
        }
        return rule;
    }
}

