/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.CertificateRequest;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationPolicy;
import net.named_data.jndn.security.v2.ValidationState;

public class ValidationPolicySimpleHierarchy
extends ValidationPolicy {
    @Override
    public void checkPolicy(Data data, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        Name keyLocatorName = ValidationPolicySimpleHierarchy.getKeyLocatorName(data, state);
        if (state.isOutcomeFailed()) {
            return;
        }
        if (keyLocatorName.getPrefix(-2).isPrefixOf(data.getName())) {
            continueValidation.continueValidation(new CertificateRequest(new Interest(keyLocatorName)), state);
        } else {
            state.fail(new ValidationError(8, "Data signing policy violation for " + data.getName().toUri() + " by " + keyLocatorName.toUri()));
        }
    }

    @Override
    public void checkPolicy(Interest interest, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        Name keyLocatorName = ValidationPolicySimpleHierarchy.getKeyLocatorName(interest, state);
        if (state.isOutcomeFailed()) {
            return;
        }
        if (keyLocatorName.getPrefix(-2).isPrefixOf(interest.getName())) {
            continueValidation.continueValidation(new CertificateRequest(new Interest(keyLocatorName)), state);
        } else {
            state.fail(new ValidationError(8, "Interest signing policy violation for " + interest.getName().toUri() + " by " + keyLocatorName.toUri()));
        }
    }
}

