/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.CertificateRequest;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.TrustAnchorContainer;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationPolicy;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.security.v2.validator_config.ConfigRule;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.BoostInfoParser;
import net.named_data.jndn.util.BoostInfoTree;
import net.named_data.jndn.util.Common;

public class ValidationPolicyConfig
extends ValidationPolicy {
    private boolean shouldBypass_ = false;
    private boolean isConfigured_ = false;
    private final ArrayList<ConfigRule> dataRules_ = new ArrayList();
    private final ArrayList<ConfigRule> interestRules_ = new ArrayList();

    public final void load(String filePath) throws IOException, ValidatorConfigError {
        BoostInfoParser parser = new BoostInfoParser();
        parser.read(filePath);
        this.load(parser.getRoot(), filePath);
    }

    public final void load(String input, String inputName) throws IOException, ValidatorConfigError {
        BoostInfoParser parser = new BoostInfoParser();
        parser.read(input, inputName);
        this.load(parser.getRoot(), inputName);
    }

    public final void load(BoostInfoTree configSection, String inputName) throws ValidatorConfigError {
        if (this.isConfigured_) {
            this.shouldBypass_ = false;
            this.dataRules_.clear();
            this.interestRules_.clear();
            this.validator_.resetAnchors();
            this.validator_.resetVerifiedCertificates();
        }
        this.isConfigured_ = true;
        ArrayList<BoostInfoTree> validatorList = configSection.get("validator");
        if (validatorList.size() != 1) {
            throw new ValidatorConfigError("ValidationPolicyConfig: Expected one validator section");
        }
        BoostInfoTree validatorSection = validatorList.get(0);
        ArrayList<BoostInfoTree> ruleList = validatorSection.get("rule");
        for (int i = 0; i < ruleList.size(); ++i) {
            ConfigRule rule = ConfigRule.create(ruleList.get(i));
            if (rule.getIsForInterest()) {
                this.interestRules_.add(rule);
                continue;
            }
            this.dataRules_.add(rule);
        }
        ArrayList<BoostInfoTree> trustAnchorList = validatorSection.get("trust-anchor");
        for (int i = 0; i < trustAnchorList.size(); ++i) {
            this.processConfigTrustAnchor(trustAnchorList.get(i), inputName);
        }
    }

    @Override
    public void checkPolicy(Data data, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        if (this.hasInnerPolicy()) {
            throw new ValidatorConfigError("ValidationPolicyConfig must be a terminal inner policy");
        }
        if (this.shouldBypass_) {
            continueValidation.continueValidation(null, state);
            return;
        }
        Name keyLocatorName = ValidationPolicyConfig.getKeyLocatorName(data, state);
        if (state.isOutcomeFailed()) {
            return;
        }
        for (int i = 0; i < this.dataRules_.size(); ++i) {
            ConfigRule rule = this.dataRules_.get(i);
            if (!rule.match(false, data.getName())) continue;
            if (rule.check(false, data.getName(), keyLocatorName, state)) {
                continueValidation.continueValidation(new CertificateRequest(new Interest(keyLocatorName)), state);
                return;
            }
            return;
        }
        state.fail(new ValidationError(9, "No rule matched for data `" + data.getName().toUri() + "`"));
    }

    @Override
    public void checkPolicy(Interest interest, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        if (this.hasInnerPolicy()) {
            throw new ValidatorConfigError("ValidationPolicyConfig must be a terminal inner policy");
        }
        if (this.shouldBypass_) {
            continueValidation.continueValidation(null, state);
            return;
        }
        Name keyLocatorName = ValidationPolicyConfig.getKeyLocatorName(interest, state);
        if (state.isOutcomeFailed()) {
            return;
        }
        for (int i = 0; i < this.interestRules_.size(); ++i) {
            ConfigRule rule = this.interestRules_.get(i);
            if (!rule.match(true, interest.getName())) continue;
            if (rule.check(true, interest.getName(), keyLocatorName, state)) {
                continueValidation.continueValidation(new CertificateRequest(new Interest(keyLocatorName)), state);
                return;
            }
            return;
        }
        state.fail(new ValidationError(9, "No rule matched for interest `" + interest.getName().toUri() + "`"));
    }

    private void processConfigTrustAnchor(BoostInfoTree configSection, String inputName) throws ValidatorConfigError {
        String anchorType = configSection.getFirstValue("type");
        if (anchorType == null) {
            throw new ValidatorConfigError("Expected <trust-anchor.type>");
        }
        if (anchorType.equalsIgnoreCase("file")) {
            String fileName = configSection.getFirstValue("file-name");
            if (fileName == null) {
                throw new ValidatorConfigError("Expected <trust-anchor.file-name>");
            }
            double refreshPeriod = ValidationPolicyConfig.getRefreshPeriod(configSection);
            try {
                this.validator_.loadAnchor(fileName, fileName, refreshPeriod, false);
            }
            catch (TrustAnchorContainer.Error ex) {
                throw new ValidatorConfigError("Error in loadAnchor: " + ex);
            }
            return;
        }
        if (anchorType.equalsIgnoreCase("base64")) {
            String base64String = configSection.getFirstValue("base64-string");
            if (base64String == null) {
                throw new ValidatorConfigError("Expected <trust-anchor.base64-string>");
            }
            byte[] encoding = Common.base64Decode(base64String);
            CertificateV2 certificate = new CertificateV2();
            try {
                certificate.wireDecode(new Blob(encoding));
            }
            catch (Exception ex) {
                throw new ValidatorConfigError("Cannot decode certificate from base64-string: " + ex);
            }
            try {
                this.validator_.loadAnchor("", certificate);
            }
            catch (TrustAnchorContainer.Error ex) {
                throw new ValidatorConfigError("Error in loadAnchor: " + ex);
            }
            return;
        }
        if (anchorType.equalsIgnoreCase("dir")) {
            String dirString = configSection.getFirstValue("dir");
            if (dirString == null) {
                throw new ValidatorConfigError("Expected <trust-anchor.dir>");
            }
            double refreshPeriod = ValidationPolicyConfig.getRefreshPeriod(configSection);
            try {
                this.validator_.loadAnchor(dirString, dirString, refreshPeriod, true);
            }
            catch (TrustAnchorContainer.Error ex) {
                throw new ValidatorConfigError("Error in loadAnchor: " + ex);
            }
            return;
        }
        if (!anchorType.equalsIgnoreCase("any")) {
            throw new ValidatorConfigError("Unsupported trust-anchor.type");
        }
        this.shouldBypass_ = true;
    }

    private static double getRefreshPeriod(BoostInfoTree configSection) {
        String refreshString = configSection.getFirstValue("refresh");
        if (refreshString == null) {
            return 1.0E14;
        }
        double refreshSeconds = 0.0;
        Pattern regex1 = Pattern.compile("(\\d+)([hms])");
        Matcher refreshMatch = regex1.matcher(refreshString);
        if (refreshMatch.find()) {
            refreshSeconds = Integer.parseInt(refreshMatch.group(1));
            if (!refreshMatch.group(2).equals("s")) {
                refreshSeconds *= 60.0;
                if (!refreshMatch.group(2).equals("m")) {
                    refreshSeconds *= 60.0;
                }
            }
        }
        if (refreshSeconds == 0.0) {
            return 3600000.0;
        }
        return refreshSeconds * 1000.0;
    }
}

