/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.CertificateRequest;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.security.v2.Validator;

public abstract class ValidationPolicy {
    protected Validator validator_ = null;
    protected ValidationPolicy innerPolicy_ = null;

    public final void setInnerPolicy(ValidationPolicy innerPolicy) {
        if (innerPolicy == null) {
            throw new IllegalArgumentException("The innerPolicy argument cannot be null");
        }
        if (this.validator_ != null) {
            innerPolicy.setValidator(this.validator_);
        }
        if (this.innerPolicy_ == null) {
            this.innerPolicy_ = innerPolicy;
        } else {
            this.innerPolicy_.setInnerPolicy(innerPolicy);
        }
    }

    public final boolean hasInnerPolicy() {
        return this.innerPolicy_ != null;
    }

    public final ValidationPolicy getInnerPolicy() {
        return this.innerPolicy_;
    }

    public final void setValidator(Validator validator) {
        this.validator_ = validator;
        if (this.innerPolicy_ != null) {
            this.innerPolicy_.setValidator(validator);
        }
    }

    public abstract void checkPolicy(Data var1, ValidationState var2, ValidationContinuation var3) throws CertificateV2.Error, ValidatorConfigError;

    public abstract void checkPolicy(Interest var1, ValidationState var2, ValidationContinuation var3) throws CertificateV2.Error, ValidatorConfigError;

    public void checkCertificatePolicy(CertificateV2 certificate, ValidationState state, ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        this.checkPolicy(certificate, state, continueValidation);
    }

    public static Name getKeyLocatorName(Data data, ValidationState state) {
        return ValidationPolicy.getKeyLocatorNameFromSignature(data.getSignature(), state);
    }

    public static Name getKeyLocatorName(Interest interest, ValidationState state) {
        Signature signatureInfo;
        Name name = interest.getName();
        if (name.size() < 2) {
            state.fail(new ValidationError(8, "Invalid signed Interest: name too short"));
            return new Name();
        }
        try {
            signatureInfo = WireFormat.getDefaultWireFormat().decodeSignatureInfoAndValue(interest.getName().get(-2).getValue().buf(), interest.getName().get(-1).getValue().buf());
        }
        catch (Throwable ex) {
            state.fail(new ValidationError(8, "Invalid signed Interest: " + ex));
            return new Name();
        }
        return ValidationPolicy.getKeyLocatorNameFromSignature(signatureInfo, state);
    }

    private static Name getKeyLocatorNameFromSignature(Signature signatureInfo, ValidationState state) {
        if (!KeyLocator.canGetFromSignature(signatureInfo)) {
            state.fail(new ValidationError(8, "KeyLocator is missing"));
            return new Name();
        }
        KeyLocator keyLocator = KeyLocator.getFromSignature(signatureInfo);
        if (keyLocator.getType() != KeyLocatorType.KEYNAME) {
            state.fail(new ValidationError(8, "KeyLocator type is not Name"));
            return new Name();
        }
        return keyLocator.getKeyName();
    }

    public final Validator getValidator_() {
        return this.validator_;
    }

    public static interface ValidationContinuation {
        public void continueValidation(CertificateRequest var1, ValidationState var2) throws CertificateV2.Error, ValidatorConfigError;
    }
}

