/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.v2.CertificateContainerInterface;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class TrustAnchorGroup {
    protected final CertificateContainerInterface certificates_;
    protected final HashSet<Name> anchorNames_ = new HashSet();
    private final String id_;

    public TrustAnchorGroup(CertificateContainerInterface certificateContainer, String id) {
        this.certificates_ = certificateContainer;
        this.id_ = id;
    }

    public final String getId() {
        return this.id_;
    }

    public final int size() {
        return this.anchorNames_.size();
    }

    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertificateV2 readCertificate(String filePath) {
        StringBuilder encodedData = new StringBuilder();
        try (BufferedReader certificateFile = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = certificateFile.readLine()) != null) {
                encodedData.append(line);
            }
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        byte[] decodedData = Common.base64Decode(encodedData.toString());
        CertificateV2 result = new CertificateV2();
        try {
            result.wireDecode(new Blob(decodedData, false));
            return result;
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

