/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Interest;
import net.named_data.jndn.security.VerificationHelpers;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.InterestValidationFailureCallback;
import net.named_data.jndn.security.v2.InterestValidationSuccessCallback;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.util.Common;

public class InterestValidationState
extends ValidationState {
    private final Interest interest_;
    private final ArrayList<InterestValidationSuccessCallback> successCallbacks_ = new ArrayList();
    private final InterestValidationFailureCallback failureCallback_;
    private static final Logger logger_ = Logger.getLogger(InterestValidationState.class.getName());
    private static Common dummyCommon_ = new Common();

    public InterestValidationState(Interest interest, InterestValidationSuccessCallback successCallback, InterestValidationFailureCallback failureCallback) {
        this.interest_ = new Interest(interest);
        this.successCallbacks_.add(successCallback);
        this.failureCallback_ = failureCallback;
        if (successCallback == null) {
            throw new IllegalArgumentException("The successCallback is null");
        }
        if (this.failureCallback_ == null) {
            throw new IllegalArgumentException("The failureCallback is null");
        }
    }

    @Override
    public void fail(ValidationError error) {
        logger_.log(Level.FINE, "" + error);
        try {
            this.failureCallback_.failureCallback(this.interest_, error);
        }
        catch (Throwable exception) {
            logger_.log(Level.SEVERE, "Error in failureCallback", exception);
        }
        this.setOutcome(false);
    }

    public final Interest getOriginalInterest() {
        return this.interest_;
    }

    public final void addSuccessCallback(InterestValidationSuccessCallback successCallback) {
        this.successCallbacks_.add(successCallback);
    }

    @Override
    public void verifyOriginalPacket_(CertificateV2 trustedCertificate) {
        if (VerificationHelpers.verifyInterestSignature(this.interest_, trustedCertificate)) {
            logger_.log(Level.FINE, "OK signature for interest `{0}`", this.interest_.getName().toUri());
            for (int i = 0; i < this.successCallbacks_.size(); ++i) {
                try {
                    this.successCallbacks_.get(i).successCallback(this.interest_);
                    continue;
                }
                catch (Throwable exception) {
                    logger_.log(Level.SEVERE, "Error in successCallback", exception);
                }
            }
            this.setOutcome(true);
        } else {
            this.fail(new ValidationError(1, "Invalid signature of interest `" + this.interest_.getName().toUri() + "`"));
        }
    }

    @Override
    public void bypassValidation_() {
        logger_.log(Level.FINE, "Signature verification bypassed for interest `{0}`", this.interest_.getName().toUri());
        for (int i = 0; i < this.successCallbacks_.size(); ++i) {
            try {
                this.successCallbacks_.get(i).successCallback(this.interest_);
                continue;
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in successCallback", exception);
            }
        }
        this.setOutcome(true);
    }
}

