/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.security.VerificationHelpers;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.DataValidationFailureCallback;
import net.named_data.jndn.security.v2.DataValidationSuccessCallback;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationState;

public class DataValidationState
extends ValidationState {
    private final Data data_;
    private final DataValidationSuccessCallback successCallback_;
    private final DataValidationFailureCallback failureCallback_;
    private static final Logger logger_ = Logger.getLogger(DataValidationState.class.getName());

    public DataValidationState(Data data, DataValidationSuccessCallback successCallback, DataValidationFailureCallback failureCallback) {
        this.data_ = new Data(data);
        this.successCallback_ = successCallback;
        this.failureCallback_ = failureCallback;
        if (this.successCallback_ == null) {
            throw new IllegalArgumentException("The successCallback is null");
        }
        if (this.failureCallback_ == null) {
            throw new IllegalArgumentException("The failureCallback is null");
        }
    }

    @Override
    public void fail(ValidationError error) {
        logger_.log(Level.FINE, "" + error);
        try {
            this.failureCallback_.failureCallback(this.data_, error);
        }
        catch (Throwable exception) {
            logger_.log(Level.SEVERE, "Error in failureCallback", exception);
        }
        this.setOutcome(false);
    }

    public final Data getOriginalData() {
        return this.data_;
    }

    @Override
    public void verifyOriginalPacket_(CertificateV2 trustedCertificate) {
        if (VerificationHelpers.verifyDataSignature(this.data_, trustedCertificate)) {
            logger_.log(Level.FINE, "OK signature for data `{0}`", this.data_.getName().toUri());
            try {
                this.successCallback_.successCallback(this.data_);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in successCallback", exception);
            }
            this.setOutcome(true);
        } else {
            this.fail(new ValidationError(1, "Invalid signature of data `" + this.data_.getName().toUri() + "`"));
        }
    }

    @Override
    public void bypassValidation_() {
        logger_.log(Level.FINE, "Signature verification bypassed for data `{0}`", this.data_.getName().toUri());
        try {
            this.successCallback_.successCallback(this.data_);
        }
        catch (Throwable exception) {
            logger_.log(Level.SEVERE, "Error in successCallback", exception);
        }
        this.setOutcome(true);
    }
}

