/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import net.named_data.jndn.ContentType;
import net.named_data.jndn.Data;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encrypt.Schedule;
import net.named_data.jndn.security.ValidityPeriod;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class CertificateV2
extends Data {
    public static final int VERSION_OFFSET = -1;
    public static final int ISSUER_ID_OFFSET = -2;
    public static final int KEY_ID_OFFSET = -3;
    public static final int KEY_COMPONENT_OFFSET = -4;
    public static final int MIN_CERT_NAME_LENGTH = 4;
    public static final int MIN_KEY_NAME_LENGTH = 2;
    public static final Name.Component KEY_COMPONENT = new Name.Component("KEY");

    public CertificateV2() {
        this.getMetaInfo().setType(ContentType.KEY);
    }

    public CertificateV2(Data data) throws Error {
        super(data);
        this.checkFormat();
    }

    private void checkFormat() throws Error {
        if (!CertificateV2.isValidName(this.getName())) {
            throw new Error("The Data Name does not follow the certificate naming convention");
        }
        if (this.getMetaInfo().getType() != ContentType.KEY) {
            throw new Error("The Data ContentType is not KEY");
        }
        if (this.getMetaInfo().getFreshnessPeriod() < 0.0) {
            throw new Error("The Data FreshnessPeriod is not set");
        }
        if (this.getContent().size() == 0) {
            throw new Error("The Data Content is empty");
        }
    }

    public final Name getKeyName() {
        return this.getName().getPrefix(-2);
    }

    public final Name getIdentity() {
        return this.getName().getPrefix(-4);
    }

    public final Name.Component getKeyId() {
        return this.getName().get(-3);
    }

    public final Name.Component getIssuerId() {
        return this.getName().get(-2);
    }

    public final Blob getPublicKey() throws Error {
        if (this.getContent().size() == 0) {
            throw new Error("The public key is not set (the Data content is empty)");
        }
        return this.getContent();
    }

    public final ValidityPeriod getValidityPeriod() {
        if (!ValidityPeriod.canGetFromSignature(this.getSignature())) {
            throw new IllegalArgumentException("The SignatureInfo does not have a ValidityPeriod");
        }
        return ValidityPeriod.getFromSignature(this.getSignature());
    }

    public final boolean isValid(double time) {
        return this.getValidityPeriod().isValid(time);
    }

    public final boolean isValid() {
        return this.getValidityPeriod().isValid();
    }

    public void printCertificate(StringBuffer result) {
        result.append("Certificate name:\n");
        result.append("  ").append(this.getName().toUri()).append("\n");
        result.append("Validity:\n");
        result.append("  NotBefore: ").append(Schedule.toIsoString(this.getValidityPeriod().getNotBefore())).append("\n");
        result.append("  NotAfter: ").append(Schedule.toIsoString(this.getValidityPeriod().getNotAfter())).append("\n");
        result.append("Public key bits:\n");
        try {
            result.append(Common.base64Encode(this.getPublicKey().getImmutableArray(), true));
        }
        catch (Error error) {
            // empty catch block
        }
        result.append("Signature Information:\n");
        result.append("  Signature Type: ");
        if (this.getSignature() instanceof Sha256WithEcdsaSignature) {
            result.append("SignatureSha256WithEcdsa\n");
        } else if (this.getSignature() instanceof Sha256WithRsaSignature) {
            result.append("SignatureSha256WithRsa\n");
        } else {
            result.append("<unknown>\n");
        }
        if (KeyLocator.canGetFromSignature(this.getSignature())) {
            result.append("  Key Locator: ");
            KeyLocator keyLocator = KeyLocator.getFromSignature(this.getSignature());
            if (keyLocator.getType() == KeyLocatorType.KEYNAME) {
                if (keyLocator.getKeyName().equals(this.getKeyName())) {
                    result.append("Self-Signed ");
                }
                result.append("Name=").append(keyLocator.getKeyName().toUri()).append("\n");
            } else {
                result.append("<no KeyLocator key name>\n");
            }
        }
    }

    @Override
    public void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        super.wireDecode(input, wireFormat);
        try {
            this.checkFormat();
        }
        catch (Error ex) {
            throw new EncodingException(ex.getMessage());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.printCertificate(result);
        return result.toString();
    }

    public static boolean isValidName(Name certificateName) {
        return certificateName.size() >= 4 && certificateName.get(-4).equals(KEY_COMPONENT);
    }

    public static Name extractIdentityFromCertName(Name certificateName) {
        if (!CertificateV2.isValidName(certificateName)) {
            throw new IllegalArgumentException("Certificate name `" + certificateName.toUri() + "` does not follow the naming conventions");
        }
        return certificateName.getPrefix(-4);
    }

    public static Name extractKeyNameFromCertName(Name certificateName) {
        if (!CertificateV2.isValidName(certificateName)) {
            throw new IllegalArgumentException("Certificate name `" + certificateName.toUri() + "` does not follow the naming conventions");
        }
        return certificateName.getPrefix(-2);
    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

