/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.tpm;

import java.nio.ByteBuffer;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.security.tpm.TpmKeyHandle;
import net.named_data.jndn.security.tpm.TpmPrivateKey;
import net.named_data.jndn.util.Blob;

public class TpmKeyHandleMemory
extends TpmKeyHandle {
    private TpmPrivateKey key_;

    public TpmKeyHandleMemory(TpmPrivateKey key) {
        if (key == null) {
            throw new AssertionError((Object)"The key is null");
        }
        this.key_ = key;
    }

    @Override
    protected Blob doSign(DigestAlgorithm digestAlgorithm, ByteBuffer data) throws TpmBackEnd.Error {
        if (digestAlgorithm == DigestAlgorithm.SHA256) {
            try {
                return this.key_.sign(data, digestAlgorithm);
            }
            catch (TpmPrivateKey.Error ex) {
                throw new TpmBackEnd.Error("Error in TpmPrivateKey.sign: " + ex);
            }
        }
        return new Blob();
    }

    @Override
    protected Blob doDecrypt(ByteBuffer cipherText) throws TpmBackEnd.Error {
        try {
            return this.key_.decrypt(cipherText);
        }
        catch (TpmPrivateKey.Error ex) {
            throw new TpmBackEnd.Error("Error in TpmPrivateKey.decrypt: " + ex);
        }
    }

    @Override
    protected Blob doDerivePublicKey() throws TpmBackEnd.Error {
        try {
            return this.key_.derivePublicKey();
        }
        catch (TpmPrivateKey.Error ex) {
            throw new TpmBackEnd.Error("Error in TpmPrivateKey.derivePublicKey: " + ex);
        }
    }
}

