/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.tpm;

import java.nio.ByteBuffer;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.util.Blob;

public abstract class TpmKeyHandle {
    private Name keyName_ = new Name();

    public final Blob sign(DigestAlgorithm digestAlgorithm, ByteBuffer data) throws TpmBackEnd.Error {
        return this.doSign(digestAlgorithm, data);
    }

    public final Blob decrypt(ByteBuffer cipherText) throws TpmBackEnd.Error {
        return this.doDecrypt(cipherText);
    }

    public final Blob derivePublicKey() throws TpmBackEnd.Error {
        return this.doDerivePublicKey();
    }

    public final void setKeyName(Name keyName) {
        this.keyName_ = new Name(keyName);
    }

    public final Name getKeyName() {
        return this.keyName_;
    }

    protected abstract Blob doSign(DigestAlgorithm var1, ByteBuffer var2) throws TpmBackEnd.Error;

    protected abstract Blob doDecrypt(ByteBuffer var1) throws TpmBackEnd.Error;

    protected abstract Blob doDerivePublicKey() throws TpmBackEnd.Error;
}

