/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.tpm;

import java.nio.ByteBuffer;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.KeyIdType;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.tpm.Tpm;
import net.named_data.jndn.security.tpm.TpmKeyHandle;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public abstract class TpmBackEnd {
    public final boolean hasKey(Name keyName) throws Error {
        return this.doHasKey(keyName);
    }

    public final TpmKeyHandle getKeyHandle(Name keyName) throws Error {
        return this.doGetKeyHandle(keyName);
    }

    public final TpmKeyHandle createKey(Name identityName, KeyParams params) throws Error, Tpm.Error {
        if (params.getKeyIdType() == KeyIdType.USER_SPECIFIED) {
            Name keyName = PibKey.constructKeyName(identityName, params.getKeyId());
            if (this.hasKey(keyName)) {
                throw new Tpm.Error("Key `" + keyName.toUri() + "` already exists");
            }
        } else if (params.getKeyIdType() != KeyIdType.SHA256) {
            if (params.getKeyIdType() == KeyIdType.RANDOM) {
                Name.Component keyId;
                Name keyName;
                ByteBuffer random = ByteBuffer.allocate(8);
                do {
                    Common.getRandom().nextBytes(random.array());
                } while (this.hasKey(keyName = PibKey.constructKeyName(identityName, keyId = new Name.Component(new Blob(random, false)))));
                params.setKeyId(keyId);
            } else {
                throw new Tpm.Error("Unsupported key id type");
            }
        }
        return this.doCreateKey(identityName, params);
    }

    public final void deleteKey(Name keyName) throws Error {
        this.doDeleteKey(keyName);
    }

    public final Blob exportKey(Name keyName, ByteBuffer password) throws Error {
        if (!this.hasKey(keyName)) {
            throw new Error("Key `" + keyName.toUri() + "` does not exist");
        }
        return this.doExportKey(keyName, password);
    }

    public final void importKey(Name keyName, ByteBuffer pkcs8, ByteBuffer password) throws Error {
        if (this.hasKey(keyName)) {
            throw new Error("Key `" + keyName.toUri() + "` already exists");
        }
        this.doImportKey(keyName, pkcs8, password);
    }

    public boolean isTerminalMode() throws Error {
        return true;
    }

    public void setTerminalMode(boolean isTerminal) throws Error {
    }

    public boolean isTpmLocked() throws Error {
        return false;
    }

    public boolean unlockTpm(ByteBuffer password) throws Error {
        return !this.isTpmLocked();
    }

    protected static void setKeyName(TpmKeyHandle keyHandle, Name identityName, KeyParams params) throws Error {
        Name.Component keyId;
        if (params.getKeyIdType() == KeyIdType.USER_SPECIFIED) {
            keyId = params.getKeyId();
        } else if (params.getKeyIdType() == KeyIdType.SHA256) {
            byte[] digest = Common.digestSha256(keyHandle.derivePublicKey().buf());
            keyId = new Name.Component(digest);
        } else if (params.getKeyIdType() == KeyIdType.RANDOM) {
            if (params.getKeyId().getValue().size() == 0) {
                throw new Error("setKeyName: The keyId is empty for type RANDOM");
            }
            keyId = params.getKeyId();
        } else {
            throw new Error("setKeyName: unrecognized params.getKeyIdType()");
        }
        keyHandle.setKeyName(PibKey.constructKeyName(identityName, keyId));
    }

    protected abstract boolean doHasKey(Name var1) throws Error;

    protected abstract TpmKeyHandle doGetKeyHandle(Name var1) throws Error;

    protected abstract TpmKeyHandle doCreateKey(Name var1, KeyParams var2) throws Error;

    protected abstract void doDeleteKey(Name var1) throws Error;

    protected Blob doExportKey(Name keyName, ByteBuffer password) throws Error {
        throw new Error("TpmBackEnd doExportKey is not implemented");
    }

    protected void doImportKey(Name keyName, ByteBuffer pkcs8, ByteBuffer password) throws Error {
        throw new Error("TpmBackEnd doImportKey is not implemented");
    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

